// services/bookService.js
import prisma from '@/lib/prismaconfig';

// Get all Knowledges

export const getAllKnowledges = async () => {
  return await prisma.acs_knowledge_base.findMany({
    include: {
      user: {
        select: {
          user_name: true,
        },
      },
    },
    where: {
      knowledge_isdelete: "active",
    },
  });
};

// Create new Knowledges
export const createKnowledge = async (data) => {
  return await prisma.acs_knowledge_base.create({
    data,
  });
};

// Get Knowledges by ID
export const getKnowledgeById = async (knowledge_pid ) => {
  return await prisma.acs_knowledge_base.findUnique({
    where: { knowledge_pid : Number(knowledge_pid ) },
  });
};

// Update Knowledges
export const updateKnowledge = async (knowledge_pid , data) => {
  return await prisma.acs_knowledge_base.update({
    where: { knowledge_pid : Number(knowledge_pid ) },
    data,
  });
};

