// services/bookService.js
import prisma from '@/lib/prismaconfig';

// Get all books

export const getAllHolidays = async () => {
  return await prisma.acs_holiday_list.findMany({
    where: {
      holiday_isdelete: "active", // 👈 filter out deleted books
    },
  });
};

// Create new book
export const createHoliday = async (data) => {
  return await prisma.acs_holiday_list.create({
    data,
  });
};

// Get book by ID
export const getHolidayById = async (holiday_pid ) => {
  return await prisma.acs_holiday_list.findUnique({
    where: { holiday_pid : Number(holiday_pid ) },
  });
};

// Update book
export const updateHoliday = async (holiday_pid , data) => {
  return await prisma.acs_holiday_list.update({
    where: { holiday_pid : Number(holiday_pid ) },
    data,
  });
};

export const getHolidayByDate = async (holiday_date) => {
  console.log(holiday_date);
  return await prisma.acs_holiday_list.findUnique({
    where: { 
      holiday_date: holiday_date, // make sure holiday_date is a unique field in your schema
    },
  });
};
