import nodemailer from "nodemailer";
import inlineBase64 from "nodemailer-plugin-inline-base64";
// import cron from 'node-cron';

// Create the transporter for sending emails
const transporter = nodemailer.createTransport({
  service: "gmail",
  auth: {
    user: process.env.AUTH_USER_EMAIL,
    pass: process.env.AUTH_USER_PASSWORD,
  },
  tls: {
    // ✅ Allow self-signed certificates (important for local or test servers)
    rejectUnauthorized: false,
    ciphers: "SSLv3",
  },
});

transporter.use("compile", inlineBase64({ cidPrefix: "somePrefix_" }));

// Define the email sending function
const sendEmail = async (
  to,
  subject,
  text,
  ccList = [],
  bccList = [],
  attachments = []
) => {
  const mailOptions = {
    from: process.env.AUTH_USER_EMAIL,
    to: to,
    subject: subject,
    cc: ccList,
    bcc: bccList,
    html: text,
    //html: text.replace(/(?:\r\n|\r|\n)/g, "<br>"),
    //html: text.replace(/\s*<br\s*[\/]?>\s*/gi, "\n").replace(/<[^>]+>/g, ""),
    attachments: attachments,
  };

  const plainHtml = text;

  // console.log(mailOptions, "mailoptions");

  try {
    const info = await transporter.sendMail(mailOptions);
    console.log("Email sent: " + info.response);
    return {
      success: true,
      message: "Email sent successfully",
      mailOptions: { ...mailOptions, plainHtml },
    };
  } catch (error) {
    console.error("Error sending email:", error);
    return { success: false, message: "Failed to send email" };
  }
};

const sendEmailTest = async (
  to,
  subject,
  text,
  ccList = [],
  bccList = [],
  attachments = []
) => {
  const mailPMOptions = {
    from: process.env.AUTH_USER_EMAIL,
    to: to,
    subject: subject,
    cc: ccList,
    bcc: bccList,
    html: text,
    attachments: attachments,
  };

  const plainHtml = text;
  // console.log(mailOptions, "mailoptions");

  try {
    const info = await transporter.sendMail(mailPMOptions);
    console.log("Email sent: " + info.response);
    return {
      success: true,
      message: "Email sent successfully",
      mailOptions: { ...mailPMOptions, plainHtml },
    };
  } catch (error) {
    console.error("Error sending email:", error);
    return { success: false, message: "Failed to send email" };
  }
};

const validateEmailCredentials = async (email, password) => {
  const transporter = nodemailer.createTransport({
    service: "gmail",
    auth: {
      user: email,
      pass: password,
    },
  });

  try {
    // Attempt to verify the connection
    await transporter.verify();
    console.log("Credentials are valid");
    return true; // Valid credentials
  } catch (error) {
    console.error("Invalid credentials:", error.message);
    return false; // Invalid credentials
  }
};

// this is for dynamic from address mail
const EmailSenderDynamic = async (
  fromEmail,
  fromPassword,
  to,
  subject,
  text,
  ccList = [],
  bccList = [],
  attachments = []
) => {
  // Validate the email credentials first
  const areCredentialsValid = await validateEmailCredentials(
    fromEmail,
    fromPassword
  );
  if (!areCredentialsValid) {
    return { success: false, message: "Invalid email or password" };
  }

  // Create a transporter for sending emails with dynamic credentials
  const transporter = nodemailer.createTransport({
    service: "gmail",
    auth: {
      user: fromEmail,
      pass: fromPassword,
    },
  });

  // Use inlineBase64 plugin if needed
  transporter.use("compile", inlineBase64({ cidPrefix: "somePrefix_" }));

  const mailOptions = {
    from: fromEmail,
    to: to,
    subject: subject,
    cc: ccList,
    bcc: bccList,
    html: text.replace(/<br\s*[\/]?>/gi, "\n"),
    plainHtml: text,
    attachments: attachments,
  };

  console.log(mailOptions, "mailoptions");

  try {
    const info = await transporter.sendMail(mailOptions);
    console.log("Email sent: " + info.response);
    return { success: true, message: "Email sent successfully" };
  } catch (error) {
    console.error("Error sending email:", error);
    return { success: false, message: "Failed to send email" };
  }
};


/**
 * 🔹 Main reusable mail function for Copyedit Reassignment
 */
const sendEmailCopyEditReAssign = async (
  to,
  subject,
  text,
  ccList = [],
  bccList = [],
  attachments = []
) => {
  const mailOptions = {
    from: `"Ebooks Copyedit Team" <${process.env.AUTH_USER_EMAIL}>`,
    to,
    subject,
    cc: ccList,
    bcc: bccList,
    html: text,
    attachments: attachments.length > 0 ? attachments : undefined,
  };

  const plainHtml = text;
  try {
    const info = await transporter.sendMail(mailOptions);
    console.log(`✅ CopyEdit Reassign Mail sent to ${to}: ${info.response}`);
    return {
      success: true,
      message: "Email sent successfully",
      messageId: info.messageId,
      mailOptions: { ...mailOptions, plainHtml },
    };
  } catch (error) {
    console.error("❌ Mail send failed:", error);
    return { success: false, message: "Failed to send email", error };
  }
};

export { sendEmail, EmailSenderDynamic, sendEmailTest, sendEmailCopyEditReAssign };
