// services/bookService.js
import prisma from '@/lib/prismaconfig';
import { encryptNumber } from '@/lib/encryption';

// Get all books
export const createCEAssign = async (payload) => {
  const entry = await prisma.acs_ce_editing_details.create({
    data: payload,
    include: {
      book: true, // <-- Include related book
      chapter: true,
      user: true,
    },
  });
  // console.log(entry);
  return entry;
};

export const selectUserDetails = async (chapter_id) => {
  return await prisma.acs_users.findMany({
    where: {
      user_is_active: "active",
      user_pid: chapter_id ,
    },
  });
};

export async function getceEditorList(taskId) {
  return await prisma.acs_users.findMany({
    where: {
      user_role : 4,
      user_is_active : "active",
    },
  });
};


export async function getCEDetailsById(EditorDetailsPid) {
  // console.log(EditorDetailsPid, "EditorDetailsPid in service");
  return await prisma.acs_ce_editing_details.findUnique({
    where: {
      ce_pid : Number(EditorDetailsPid),
       chapter: {
        chap_currentStage: 'CE', // Only include if chapter stage is 'CE'
      },
    },
    include: {
      chapter: {
        select: {
          chap_pid: true,
          chap_bookTitle: true,
          chap_title: true,
          chap_currentStage: true,
        },
      },
      book: {
        select: {
          book_pid: true,
          book_title: true,
        },
      },
      user: {
        select: {
          user_name: true,
          user_email: true, 
        },
      },
    },
  });
}

export const CEDetailsUpdate = async (ce_pid, data) => {
  return await prisma.acs_ce_editing_details.update({
    where: { ce_pid: Number(ce_pid) },
    data,
  });
};

export const getAllCeEditingDetails = async (user_pid) => {
  const query = `
  SELECT ce.*, b.book_title, ch.chap_title
  FROM acs_ce_editing_details ce
  LEFT JOIN acs_books b ON ce.ce_book_id = b.book_pid
  LEFT JOIN acs_chapters ch ON ce.ce_chap_id = ch.chap_pid
  WHERE ce.ce_editor_id = '${Number(user_pid)}'
  ORDER BY ce.ce_createdAt DESC
`;
const results = await prisma.$queryRawUnsafe(query);
console.log(results, "Results in service");

  // Add encrypted ID to each result
  return results.map(record => ({
    ...record,
    encrypted_ce_pid: encryptNumber(record.ce_pid),
  }));
};
