import crypto from "crypto";
 
const IV_LENGTH = 16;
 
function getSecretKey() {

  const ENCRYPTION_SECRET = process.env.ENCRYPTION_SECRET;

  if (!ENCRYPTION_SECRET) {

    throw new Error("ENCRYPTION_SECRET environment variable is missing.");

  }
 
  return crypto.createHash("sha256").update(ENCRYPTION_SECRET).digest();

}
 
// --- Exported Functions (URL-Safe) ---

function base64ToUrlSafe(base64) {

  return base64.replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/, '');

}
 
function urlSafeToBase64(base64url) {

  let base64 = base64url.replace(/-/g, '+').replace(/_/g, '/');

  const padding = (4 - base64.length % 4) % 4;

  return base64 + '='.repeat(padding);

}
 
export function encryptNumber(number) {

  const iv = crypto.randomBytes(IV_LENGTH);

  const SECRET_KEY = getSecretKey();
 
  const cipher = crypto.createCipheriv("aes-256-cbc", SECRET_KEY, iv);

  let encrypted = cipher.update(number.toString());

  encrypted = Buffer.concat([encrypted, cipher.final()]);

  const combined = Buffer.concat([iv, encrypted]);

  return base64ToUrlSafe(combined.toString("base64"));

}
 
export function decryptNumber(encryptedText) {

  const SECRET_KEY = getSecretKey(); 
  console.log(SECRET_KEY,"SECRET_KEY");
  
  const base64 = urlSafeToBase64(encryptedText);

  const combined = Buffer.from(base64, "base64");
 
  if (combined.length < IV_LENGTH + 16) {

    throw new Error("Invalid ciphertext format or length.");

  }
 
  const iv = combined.slice(0, IV_LENGTH);

  const encryptedTextBuffer = combined.slice(IV_LENGTH);
 
  const decipher = crypto.createDecipheriv("aes-256-cbc", SECRET_KEY, iv);

  let decrypted = decipher.update(encryptedTextBuffer);

  decrypted = Buffer.concat([decrypted, decipher.final()]);

  return parseInt(decrypted.toString(), 10);

}