// app/books/create/actions.js
'use server';

import { createEntry, updateEntry, getEntryById, createStage, getQCEmailById, createPendingEntry, updateResumeEntry, getPendingEntryById, fetchPendingEntries,getPendingDurationById, bookReportDetails,bookallReportDetails } from '@/lib/services/entryService';
import { updateChapter, fetchChapterDetailsforQC, fetchChapterDetailsforRCQC, getChapterById, getChaptersByBookId, getFilterChaptersByBookId, getTaskById } from '@/lib/services/chapterService';
import { createBreakResponse, updateBreakResponse, getBreakById, CheckBreaks, CheckEntrys, PendingCheckEntrys } from '@/lib/services/BreaksServices';
import { userperformanceReportDetails, userallperformanceDetails } from '@/lib/services/userperformanceService';
import fs from "fs";
import path from "path";
import moment from 'moment';
import { sendEmail } from '@/lib/services/emailService';

export async function createEntryAction(payload) {
  try {
    const createdEntry = await createEntry(payload);
    return {
      success: true,
      message: "Entry created successfully",
      createdEntry
    };
  } catch (error) {
    console.error("Error creating entry:", error);
    return {
      success: false,
      message: "Server error during entry create"
    };
  }
}


export async function updateEntryAction(entryId, payload) {
  try {
    // First update with incoming payload (usually sets end_date)
    await updateEntry(entryId, payload);

    const entry_data = await getEntryById(entryId);
    if (!entry_data) {
      return { success: false, message: "Entry ID not found" };
    }

    const currentTime = new Date();
    const endTime = currentTime.toTimeString().split(" ")[0];

    // Update entry with end_time and duration
    const updatedData = {
      entry_end_time: endTime,
      //entry_duration: duration,
    };

    await updateEntry(entryId, updatedData);

    const finalData = await getEntryById(entryId);
    const chapterDetails = await getChapterById(finalData.entry_chapterId)

    return {
      success: true,
      message: "Entry updated successfully",
      entry: finalData,
      chapterDetails
    };
  } catch (error) {
    console.error("Error updating entry:", error);
    return {
      success: false,
      message: "Server error during entry update",
      error: error.message,
    };
  }
}
const timeToSeconds = (timeStr) => {
  const [h, m, s] = timeStr.split(":").map(Number);
  return h * 3600 + m * 60 + s;
};

// Helper: convert seconds → HH:MM:SS
const secondsToTime = (totalSeconds) => {
  const hours = Math.floor(totalSeconds / 3600);
  const minutes = Math.floor((totalSeconds % 3600) / 60);
  const seconds = totalSeconds % 60;
  return `${String(hours).padStart(2, "0")}:${String(minutes).padStart(2, "0")}:${String(seconds).padStart(2, "0")}`;
};

export async function updateFinalEntryAction(entryId, formData) {
  try {
    const entry_chapterId = formData.get("entry_chapterId");
    const entry_comments = formData.get("entry_comments");
    const entry_wordcount = formData.get("entry_wordcount");
    const entry_contact_email = formData.get("entry_contact_email");
    const entry_status = formData.get("entry_status");

    const entry_data = await getEntryById(entryId);
    const user_email_data = await getQCEmailById(entry_contact_email);
    // const chapterDetails = await getChapterById(entry_data.entry_chapterId);
  
    if (!entry_data) {
      return { success: false, message: "Entry ID not found" };
    }
    
    // Parse start and end datetime
    const startDateTime = new Date(`${entry_data.entry_date}T${entry_data.entry_start_time}`);
    const currentTime = new Date();
    const endTime = currentTime.toTimeString().split(" ")[0];
    const endDate = currentTime.toISOString().split("T")[0];
    const endDateTime = new Date(`${endDate}T${endTime}`);

    const durationMs = endDateTime - startDateTime;

    if (durationMs < 0) {
      return { success: false, message: "End time cannot be before start time" };
    }

    // Format duration as HH:MM:SS
    const totalSeconds = Math.floor(durationMs / 1000);
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const seconds = totalSeconds % 60;

    let duration = `${hours.toString().padStart(2, "0")}:${minutes
      .toString()
      .padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;

    const pending_data = await getPendingDurationById(entryId);
    //  console.log(pending_data);
    //  console.log(duration);
    if (pending_data) {
      const durationSeconds = timeToSeconds(duration);
      const pendingSeconds = timeToSeconds(pending_data);
      const remainingSeconds = Math.max(0, durationSeconds - pendingSeconds);
      duration = secondsToTime(remainingSeconds);
    }


    const updatedData = {
      entry_comments,
      entry_wordcount: Number(entry_wordcount),
      entry_email: Number(entry_contact_email),
      entry_status: Number(entry_status),
      entry_end_time: endTime,
      entry_end_date: endDate,
      entry_duration: duration,
    };

    const updateDatawordcount = {
      chap_wordcount: Number(entry_wordcount),
    }
    if(entry_contact_email){
        const updatedDatacontact_email = {
        chap_contact_qc_user: Number(entry_contact_email),
      }
      await updateChapter(entry_chapterId, updatedDatacontact_email);

    }
    
    // Handle file upload
    const file = formData.get("entry_upload_file");
    if (file && file.name) {
      const arrayBuffer = await file.arrayBuffer();
      const buffer = Buffer.from(arrayBuffer);

      const ext = path.extname(file.name);
      const timestamp = Date.now(); // Prevent filename conflict
      const newFilename = `${timestamp}_${file.name}`;
      const newPath = path.join(process.cwd(), "public", "First_check", newFilename);

      fs.writeFileSync(newPath, buffer);

      updatedData.entry_file = newFilename;
    }

    // Update entry
    await updateEntry(entryId, updatedData);
    await updateChapter(entry_chapterId, updateDatawordcount);
    const entry_data_res = await getEntryById(entryId);

    const chapterDetails = await getChapterById(entry_data_res.entry_chapterId)

    // Determine stage transition
    let from_stage = "";
    let to_stage = "";

    if (entry_data_res.entry_taskId == 1 && entry_status == 1) {
      from_stage = "FC";
      to_stage = "FCQC";
    } else if (entry_data_res.entry_taskId == 1 && entry_status == 2) {
      from_stage = "FC";
      to_stage = "FCR";
    } else if (entry_data_res.entry_taskId == 2 && entry_status == 1) {
      from_stage = "FCR";
      to_stage = "FCQC";
    } else if (entry_data_res.entry_taskId == 2 && entry_status == 2) {
      from_stage = "FCR";
      to_stage = "FCR";
    } else if (entry_data_res.entry_taskId == 3 && entry_status == 6) {
      from_stage = "RCR1";
      to_stage = "RCR1";
    } else if (entry_data_res.entry_taskId == 4 && entry_status == 6) {
      from_stage = "RCR2";
      to_stage = "RCR2";
    } else if (entry_data_res.entry_taskId == 5 && entry_status == 6) {
      from_stage = "RCR3";
      to_stage = "RCR3";
    } else if (entry_data_res.entry_taskId == 3 && chapterDetails.chap_copyEditing == "yes" && entry_status == 1) {
      from_stage = "RCR1";
      to_stage = "CE";
    } else if (entry_data_res.entry_taskId == 3 && entry_status == 1) {
      from_stage = "RCR1";
      to_stage = "ER";
    } else if (entry_data_res.entry_taskId == 4 && entry_status == 1) {
      from_stage = "RCR2";
      to_stage = "ER";
    } else if (entry_data_res.entry_taskId == 5 && entry_status == 1) {
      from_stage = "RCR3";
      to_stage = "ER";
    }

    // Create new stage
    const now = new Date();
    const stageData = {
      stage_bookId: Number(entry_data_res.entry_bookId),
      stage_chapId: Number(entry_data_res.entry_chapterId),
      stage_entryId: Number(entryId),
      stage_notes: entry_comments,
      stage_uploadFile: entry_data_res.entry_file,
      stage_status: Number(entry_status),
      stage_dispachDate: now.toISOString().split("T")[0],
      stage_from: from_stage,
      stage_to: to_stage,
      stage_createdBy: entry_data_res.entry_createdBy,
    };

    await createStage(stageData);

    // Update chapter stage
    const chapterData = {
      chap_currentStage: to_stage,
      chap_copyEditingStatus : 1
    };
    await updateChapter(entry_data_res.entry_chapterId, chapterData);

    // Send email if completed in first check
  
    if ((entry_data_res.entry_taskId == 1 || entry_data_res.entry_taskId == 2) && entry_status == 1) {
    //console.log('test');
      try {
        const email_data = await getQCEmailById(entry_contact_email);
        if (!email_data) {
          return { success: false, message: "Email ID not found" };
        }

        const to = email_data.user_email;
        const subject = `New Chapter ${chapterDetails?.chap_title} Moved for QC Review`;
        
        const formattedDate = moment().format("DD MMMM YYYY");
        let text = "";
        if (entry_data_res.entry_taskId == 1 && entry_status == 1) {

        text = `
                <div style="font-family: Calibri, Arial, sans-serif; font-size:15px; color:#000000; 
                line-height:1.2;max-width:600px;margin-bottom:10px;">

                  <!-- Greeting -->
                  <p>Hi ${user_email_data?.user_name},</p>

                  <!-- Intro -->
                  <p>New chapter ${chapterDetails?.chap_title} has Moved for QC Review.</p>
                  <p>Best Regards,<br>
                    ACS Team</p>
                </div> 
            `;

            // console.log(text,"email text");
        }else{
                text = `
                  <p>Dear Team,</p>
                  <p>This is a trial email to check email service functionality. Just ignore this email.</p>
                  <p>Thank you,</p>
                  <p>ACS Team</p>
                  <p>${formattedDate}</p>
                `;
        }




        const cc = [];
        const bcc =  process.env.QC_BCCEMAILS ? process.env.QC_BCCEMAILS.split(",").map(email => email.trim()) : [];

        const mailResult = await sendEmail(to, subject, text, cc, bcc);

        return {
          success: true,
          message: "Entry updated and email sent successfully",
          email: mailResult,
        };
      } catch (error) {
        console.error("Error sending email:", error);
        return { success: false, message: "Error sending email" };
      }
    }

    // ✅ Default success response if no email is sent
    return {
      success: true,
      message: "Entry updated successfully",
    };

  } catch (error) {
    console.error("Error updating entry:", error);
    return { success: false, message: "Server error during entry update" };
  }
}


export async function createPending(payload) {
  try {
    const pendingEntry = await createPendingEntry(payload);
    return {
      success: true,
      message: "Pending entry created successfully",
      pendingEntry
    };
  } catch (error) {
    console.error("Error creating entry:", error);
    return {
      success: false,
      message: "Server error during entry create"
    };
  }
}

export async function updateResume(pendingId, payload) {
  try {
    // First update with incoming payload (usually sets end_date)
    await updateResumeEntry(pendingId, payload);

    const pending_entry_data = await getPendingEntryById(pendingId);
    if (!pending_entry_data) {
      return { success: false, message: "Pending ID not found" };
    }

    // Parse start and end datetime
    const startDateTime = new Date(`${pending_entry_data.pr_pendingDate}T${pending_entry_data.pr_pendingTime}`);
    const currentTime = new Date();
    const endTime = currentTime.toTimeString().split(" ")[0];
    const endDate = currentTime.toISOString().split("T")[0];
    const endDateTime = new Date(`${endDate}T${endTime}`);

    const durationMs = endDateTime - startDateTime;

    if (durationMs < 0) {
      return { success: false, message: "End time cannot be before start time" };
    }

    // Format duration as HH:MM:SS
    const totalSeconds = Math.floor(durationMs / 1000);
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const seconds = totalSeconds % 60;

    const duration = `${hours.toString().padStart(2, "0")}:${minutes
      .toString()
      .padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;

    // Update entry with end_time and duration
    const updatedData = {
      pr_resumeDate: endDate,
      pr_resumeTime: endTime,
      pr_duration: duration,
    };

    await updateResumeEntry(pendingId, updatedData);

    return {
      success: true,
      message: "Resume updated successfully",
    };
  } catch (error) {
    console.error("Error updating entry:", error);
    return {
      success: false,
      message: "Server error during entry update",
      error: error.message,
    };
  }
}

export async function createBreak(payload) {
  try {
    const createdEntry = await createBreakResponse(payload);
    return {
      success: true,
      message: "Break started successfully",
      createdEntry
    };
  } catch (error) {
    console.error("Error creating entry:", error);
    return {
      success: false,
      message: "Server error during entry create"
    };
  }
}

export async function updateBreak(breakId, payload) {
  try {
    // First update with incoming payload (usually sets end_date)
    await updateBreakResponse(breakId, payload);

    const break_entry_data = await getBreakById(breakId);
    if (!break_entry_data) {
      return { success: false, message: "Break ID not found" };
    }

    // Parse start and end datetime
    const startDateTime = new Date(`${break_entry_data.bh_startDate}T${break_entry_data.bh_startTime}`);
    const currentTime = new Date();
    const endTime = currentTime.toTimeString().split(" ")[0];
    const endDate = currentTime.toISOString().split("T")[0];
    const endDateTime = new Date(`${endDate}T${endTime}`);

    const durationMs = endDateTime - startDateTime;

    if (durationMs < 0) {
      return { success: false, message: "End time cannot be before start time" };
    }

    // Format duration as HH:MM:SS
    const totalSeconds = Math.floor(durationMs / 1000);
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const seconds = totalSeconds % 60;

    const duration = `${hours.toString().padStart(2, "0")}:${minutes
      .toString()
      .padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;

    // Update entry with end_time and duration
    const updatedData = {
      bh_endDate: endDate,
      bh_endTime: endTime,
      bh_duration: duration,
    };

    await updateBreakResponse(breakId, updatedData);

    return {
      success: true,
      message: "Break updated successfully",
    };
  } catch (error) {
    console.error("Error updating entry:", error);
    return {
      success: false,
      message: "Server error during entry update",
      error: error.message,
    };
  }
}


export async function checkBreaksAction(user_pid) {
  try {
    const count = await CheckBreaks(user_pid);
    return {
      success: true,
      message: "Pending break count",
      count
    };
  } catch (error) {
    console.error("Error creating entry:", error);
    return {
      success: false,
      message: "Server error during entry create"
    };
  }
}

export async function checkEntryAction(user_pid) {
  try {
    const entry_count = await CheckEntrys(user_pid);
    const pending_count = await PendingCheckEntrys(user_pid);
    let count = 0;
    if(entry_count == 1 && pending_count == 0){
       count = 1;
    }
    return {
      success: true,
      message: "Pending entry count",
      count
    };
  } catch (error) {
    console.error("Error creating entry:", error);
    return {
      success: false,
      message: "Server error during entry create"
    };
  }
}



export async function fetchChapterDetailsforQCAction(chap_pid) {
  try {
    const result = await fetchChapterDetailsforQC(chap_pid);
    console.log(result);
    return {
      success: true,
      message: "Chapter Details",
      result
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function fetchChapterDetailsforRCQCAction(chap_pid) {
  // console.log("tewst")
  try {
    const result = await fetchChapterDetailsforRCQC(chap_pid);
    console.log(result);
    return {
      success: true,
      message: "Chapter Details",
      result
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}


export async function updateQCEntryAction(formData) {
  try {
    const ce_required = formData.get("ce_required");
    const status = formData.get("status");
    const qc_notes = formData.get("qc_notes");
    const chapterId = formData.get("chapterId");
    const user_pid = formData.get("user_pid");


    let QCUploadFilePath = null;
    const file = formData.get("qc_edited_file");

    if (file && file.name) {
      const arrayBuffer = await file.arrayBuffer();
      const buffer = Buffer.from(arrayBuffer);

      // get extension from uploaded file
      const ext = path.extname(file.name);
      const newFilename = file.name;
      const newPath = path.join(process.cwd(), "public", "QCFiles", newFilename);

      // save file
      fs.writeFileSync(newPath, buffer);

      // only save filename in DB
      QCUploadFilePath = newFilename;
    }

    let from_stage = "";
    let to_stage = "";

    if (status == 1) {
      from_stage = "FCQC";
      to_stage = "EDA";
    } else if (status == 2) {
      from_stage = "FCQC";
      to_stage = "FCR";
    }
    const chapterDetails = await getChapterById(chapterId)
    const now = new Date();
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: qc_notes,
      stage_uploadFile: QCUploadFilePath,
      stage_status: Number(status),
      stage_dispachDate: now.toISOString().split("T")[0],
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_pid),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
      chap_copyEditing: ce_required
    };
    const updatedChapter = await updateChapter(chapterId, chapterData);
    return {
      success: true,
      message: "QC upload successfully",
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}


export async function RCBTRUpdateAction(formData) {
  try {
    const re_bt_review_comments = formData.get("re_bt_review_comments");
    const status = formData.get("re_bt_review_status");
    const re_bt_review_date = formData.get("re_bt_review_date");
    const chapterId = formData.get("chapterId");
    const user_pid = formData.get("user_pid");


    let UploadFilePath = null;
    const file = formData.get("re_bt_review_file");

    if (file && file.name) {
      const arrayBuffer = await file.arrayBuffer();
      const buffer = Buffer.from(arrayBuffer);

      // get extension from uploaded file
      const ext = path.extname(file.name);
      const newFilename = file.name;
      const newPath = path.join(process.cwd(), "public", "RevCheckReviewedFiles", newFilename);

      // save file
      fs.writeFileSync(newPath, buffer);

      // only save filename in DB
      UploadFilePath = newFilename;
    }

    let to_stage = "";

    if (status == 1) {
      to_stage = "RCER";
    } else if (status == 4) {
      to_stage = "RCQC";
    }
    const chapterDetails = await getChapterById(chapterId)
    const now = new Date();
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: re_bt_review_comments,
      stage_uploadFile: UploadFilePath,
      stage_status: Number(status),
      stage_dispachDate: now.toISOString().split("T")[0],
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_pid),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
    };
    const updatedChapter = await updateChapter(chapterId, chapterData);


    return {
      success: true,
      message: "QC upload successfully",
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}


export async function BookChapterAction(book_pid) {
  try {
    const chapters = await getChaptersByBookId(book_pid);
    // console.log(result);
    return {
      success: true,
      message: "Chapter Details",
      chapters
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function BookTaskAction(chap_pid) {
  try {
    const chapterDetails = await getChapterById(chap_pid);
    let task_id = "";
    if (chapterDetails.chap_currentStage == "FC") {
      task_id = 1;
    } else if (chapterDetails.chap_currentStage == "FCR") {
      task_id = 2;
    } else if (chapterDetails.chap_currentStage == "RCR1") {
      task_id = 3;
    } else if (chapterDetails.chap_currentStage == "RCR2") {
      task_id = 4;
    }
    const tasks = await getTaskById(task_id);
    // console.log(result);
    return {
      success: true,
      message: "Task Details",
      tasks,
      chapterDetails
    };
  } catch (error) {
    console.error("Error creating task details:", error);
    return {
      success: false,
      message: "Server error during task details"
    };
  }
}

export async function BookFilterChapterAction(book_pid) {
  try {
    const chapters = await getFilterChaptersByBookId(book_pid);
    // console.log(result);
    return {
      success: true,
      message: "Chapter Details",
      chapters
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function fetchPendingEntriesAction(entryId) {
  try {
    const result = await fetchPendingEntries(entryId);
    // console.log(result);
    return {
      success: true,
      message: "Pending Details",
      result
    };
  } catch (error) {
    console.error("Error creating pending details:", error);
    return {
      success: false,
      message: "Server error during pending details"
    };
  }
}



export async function EDAUpdate(payload) {
  try {
    const user_id = payload.user_id;
    const chap_id = payload.chap_id;
    const status = payload.status;
    const end_date = payload.end_date;
    const comments = payload.comments;
    let from_stage = "";
    let to_stage = "";

    if (status == 1) {
      from_stage = "EDA";
      to_stage = "PR";
    } else if (status == 2) {
      from_stage = "EDA";
      to_stage = "EDA";
    }
    const chapterDetails = await getChapterById(chap_id)
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: comments,
      stage_uploadFile: "",
      stage_status: Number(status),
      stage_dispachDate: end_date,
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_id),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
    };
    const updatedChapter = await updateChapter(chap_id, chapterData);
    return {
      success: true,
      message: "EDA status updated successfully",
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}


export async function PRUpdate(payload) {
  try {
    const user_id = payload.user_id;
    const chap_id = payload.chap_id;
    const status = payload.status;
    const end_date = payload.end_date;
    const comments = payload.comments;
    let from_stage = "";
    let to_stage = "";

    if (status == 1) {
      from_stage = "PR";
      to_stage = "MD";
    } else if (status == 2) {
      from_stage = "PR";
      to_stage = "PR";
    }
    const chapterDetails = await getChapterById(chap_id)
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: comments,
      stage_uploadFile: "",
      stage_status: Number(status),
      stage_dispachDate: end_date,
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_id),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
    };
    const updatedChapter = await updateChapter(chap_id, chapterData);
    return {
      success: true,
      message: "PR status updated successfully",
    };
  } catch (error) {
    console.error("Error creating PR status details:", error);
    return {
      success: false,
      message: "Server error during PR status"
    };
  }
}

export async function MDUpdate(payload) {
  try {
    const user_id = payload.user_id;
    const chap_id = payload.chap_id;
    const status = payload.status;
    const end_date = payload.end_date;
    const comments = payload.comments;
    let from_stage = "";
    let to_stage = "";

    if (status == 3) {
      from_stage = "MD";
      to_stage = "MD";
    } else if (status == 4) {
      from_stage = "MD";
      to_stage = "MD";
    }  else if (status == 5) {
      from_stage = "MD";
      to_stage = "RCR1";
    }
    const chapterDetails = await getChapterById(chap_id)
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: comments,
      stage_uploadFile: "",
      stage_status: Number(status),
      stage_dispachDate: end_date,
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_id),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
    };
    const updatedChapter = await updateChapter(chap_id, chapterData);
    return {
      success: true,
      message: "MD status updated successfully",
    };
  } catch (error) {
    console.error("Error creating MD status details:", error);
    return {
      success: false,
      message: "Server error during MD status"
    };
  }
}


export async function RCERUpdate(payload) {
  try {
    const user_id = payload.user_id;
    const chap_id = payload.chap_id;
    const status = payload.status;
    const end_date = payload.end_date;
    const comments = payload.comments;
    let from_stage = "";
    let to_stage = "";

    if (status == 3) {
      from_stage = "MD";
      to_stage = "MD";
    } else if (status == 4) {
      from_stage = "MD";
      to_stage = "MD";
    }  else if (status == 5) {
      from_stage = "MD";
      to_stage = "RCR1";
    }
    const chapterDetails = await getChapterById(chap_id)
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: comments,
      stage_uploadFile: "",
      stage_status: Number(status),
      stage_dispachDate: end_date,
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_id),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
    };
    const updatedChapter = await updateChapter(chap_id, chapterData);
    return {
      success: true,
      message: "MD status updated successfully",
    };
  } catch (error) {
    console.error("Error creating MD status details:", error);
    return {
      success: false,
      message: "Server error during MD status"
    };
  }
}

export async function updateFinalAllEntryAction(entryId, formData) {

  const entry_comments = formData.get("entry_comments");
  const entry_start_date = formData.get("entry_start_date");
  const entry_start_time = formData.get("entry_start_time");
  const entry_end_date = formData.get("entry_end_date");
  const entry_end_time = formData.get("entry_end_time");
  
  // // const entry_data = await getEntryById(entryId);
  
  const startDateTime = `${entry_start_date}T${entry_start_time}`;
  const endDateTime = `${entry_end_date}T${entry_end_time}`;

  const startTimestamp = Date.parse(startDateTime);
  const endTimestamp = Date.parse(endDateTime);

  const durationMs = endTimestamp - startTimestamp;

  if (durationMs < 0) {
    return { success: false, message: "End time cannot be before start time" };
  }

  const totalSeconds = Math.floor(durationMs / 1000);
  const hours = Math.floor(totalSeconds / 3600);
  const minutes = Math.floor((totalSeconds % 3600) / 60);
  const seconds = totalSeconds % 60;

  let duration = `${hours.toString().padStart(2, "0")}:${minutes
      .toString()
      .padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;

  const pending_data = await getPendingDurationById(entryId);
  if (pending_data) {
    const durationSeconds = timeToSeconds(duration);
    const pendingSeconds = timeToSeconds(pending_data);
    const remainingSeconds = Math.max(0, durationSeconds - pendingSeconds);
    duration = secondsToTime(remainingSeconds);
  }  

    const updatedData = {
      entry_comments,
      entry_date: entry_start_date,
      entry_start_time: entry_start_time,
      entry_end_date: entry_end_date,
      entry_end_time: entry_end_time,
      entry_duration: duration,
    };
    await updateEntry(entryId, updatedData);
    return {
      success: true,
      message: "Entry updated successfully",
    };
}


export async function updateFinalAllPendingEntryAction(pendingId, pendingEntryId, pendingPayload) {

  const Pending_date = pendingPayload.Pending_date;
  const Pending_time = pendingPayload.Pending_time;
  const Resume_date = pendingPayload.Resume_date;
  const Resume_time = pendingPayload.Resume_time;
  
  const entry_data = await getEntryById(pendingEntryId);
  
  const startDateTime = `${entry_data.entry_date}T${entry_data.entry_start_time}`;
  const endDateTime = `${entry_data.entry_end_date}T${entry_data.entry_end_time}`;

  const startTimestamp = Date.parse(startDateTime);
  const endTimestamp = Date.parse(endDateTime);

  const durationMs = endTimestamp - startTimestamp;

  // if (durationMs < 0) {
  //   return { success: false, message: "End time cannot be before start time" };
  // }

  const totalSeconds = Math.floor(durationMs / 1000);
  const hours = Math.floor(totalSeconds / 3600);
  const minutes = Math.floor((totalSeconds % 3600) / 60);
  const seconds = totalSeconds % 60;

  let duration = `${hours.toString().padStart(2, "0")}:${minutes
      .toString()
      .padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;

  const pendingDateTime = `${Pending_date}T${Pending_time}`;
  const resumeDateTime = `${Resume_date}T${Resume_time}`;

  const pendingTimestamp = Date.parse(pendingDateTime);
  const resumeTimestamp = Date.parse(resumeDateTime);

  const pendingdurationMs = resumeTimestamp - pendingTimestamp;

  const pendingresumetotalSeconds = Math.floor(pendingdurationMs / 1000);
  const pendingresumehours = Math.floor(pendingresumetotalSeconds / 3600);
  const pendingresumeminutes = Math.floor((pendingresumetotalSeconds % 3600) / 60);
  const pendingresumeseconds = pendingresumetotalSeconds % 60;

  let pendingresumeduration = `${pendingresumehours.toString().padStart(2, "0")}:${pendingresumeminutes
      .toString()
      .padStart(2, "0")}:${pendingresumeseconds.toString().padStart(2, "0")}`;

    const durationSeconds = timeToSeconds(duration);
    const pendingSeconds = timeToSeconds(pendingresumeduration);
    const remainingSeconds = Math.max(0, durationSeconds - pendingSeconds);
    duration = secondsToTime(remainingSeconds);

    const updatedData = {
      entry_duration: duration,
    };
    await updateEntry(pendingEntryId, updatedData);
    const updatedPendingresumeData = {
      pr_pendingDate: Pending_date,
      pr_pendingTime: Pending_time,
      pr_resumeDate: Resume_date,
      pr_resumeTime: Resume_time,
      pr_duration: pendingresumeduration,
    };
    await updateResumeEntry(pendingId, updatedPendingresumeData);
    return {
      success: true,
      message: "Pending Entry updated successfully",
    };
}

export async function DeleteEntryAction(entryId, payload) {
  try {
    const entrys = await updateEntry(entryId, payload);
    return {
      success: true,
      message: "Entry updated Successfully",
      entrys
    };
  } catch (error) {
    console.error("Error updateing entry details:", error);
    return {
      success: false,
      message: "Server error during entry details"
    };
  }
}

 export async function createBookReportAction(payload) {
  try {
    const bookreport = await bookReportDetails(payload);
    return {
      success: true,
      message: "Report Successfully",
      bookreport
    };
  } catch (error) {
    console.error("Error updateing entry details:", error);
    return {
      success: false,
      message: "Server error during entry details"
    };
  }
} 
 export async function allBookReportList(payload) {
  try {
    const bookreportlist = await bookallReportDetails(payload);
    return {
      success: true,
      message: "Report Successfully",
      bookreportlist
    };
  } catch (error) {
    console.error("Error updateing entry details:", error);
    return {
      success: false,
      message: "Server error during entry details"
    };
  }
}

 export async function createUserPerformanceReportAction(payload) {
  try {
    const userperformancereport = await userperformanceReportDetails(payload);
    return {
      success: true,
      message: "Report Successfully",
      userperformancereport
    };
  } catch (error) {
    console.error("Error updateing entry details:", error);
    return {
      success: false,
      message: "Server error during entry details"
    };
  }
} 

export async function alluserperformanceReportList(payload) {
  try {
    const userperformancereportlist = await userallperformanceDetails(payload);
   
    return {
      success: true,
      message: "Report Successfully",
      userperformancereportlist
    };
  } catch (error) {
    console.error("Error updateing entry details:", error);
    return {
      success: false,
      message: "Server error during entry details"
    };
  }
}

export async function updateRCQCEntryAction(formData) {
  try {
    // const ce_required = formData.get("ce_required");
    const status = formData.get("status");
    const rcqc_notes = formData.get("rcqc_notes");
    const chapterId = formData.get("chapterId");
    const user_pid = formData.get("user_pid");


    let RCQCUploadFilePath = null;
    const file = formData.get("rcqc_edited_file");

    if (file && file.name) {
      const arrayBuffer = await file.arrayBuffer();
      const buffer = Buffer.from(arrayBuffer);

      // get extension from uploaded file
      const ext = path.extname(file.name);
      const newFilename = file.name;
      const newPath = path.join(process.cwd(), "public", "RCQCFiles", newFilename);

      // save file
      fs.writeFileSync(newPath, buffer);

      // only save filename in DB
      RCQCUploadFilePath = newFilename;
    }

    // let from_stage = "RCQC";
    let to_stage = "RCBTR";

    // if (status == 1) {
    //   from_stage = "RCQC";
    //   to_stage = "RCBTR";
    // } else if (status == 2) {
    //   from_stage = "RCQC";
    //   to_stage = "RCBTR";
    // }
    const chapterDetails = await getChapterById(chapterId)
    const now = new Date();
    const stageData = {
      stage_bookId: Number(chapterDetails.chap_bookTitle),
      stage_chapId: Number(chapterDetails.chap_pid),
      stage_notes: rcqc_notes,
      stage_uploadFile: RCQCUploadFilePath,
      stage_status: Number(status),
      stage_dispachDate: now.toISOString().split("T")[0],
      stage_from: chapterDetails.chap_currentStage,
      stage_to: to_stage,
      stage_createdBy: Number(user_pid),
    };
    const createdStage = await createStage(stageData);
    const chapterData = {
      chap_currentStage: to_stage,
      // chap_copyEditing: ce_required
    };
    const updatedChapter = await updateChapter(chapterId, chapterData);
    return {
      success: true,
      message: "RCQC upload successfully",
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}





