// app/chapter/create/actions.js
'use server';

import { createChapter, updateChapter, getBookIdChapters } from '@/lib/services/chapterService';

export async function createChapterAction(payload) {
  try {
    const chapters = await createChapter(payload);
    return {
      success: true,
      message: "Chapter Created Successfully",
      chapters
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function updateChapterAction(chapterId, payload) {
  try {
    const chapters = await updateChapter(chapterId, payload);
    return {
      success: true,
      message: "Chapter updated Successfully",
      chapters
    };
  } catch (error) {
    console.error("Error updateing chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function GetChapterByIdAction(book_pid) {
  try {
    const chapters = await getBookIdChapters(book_pid);
    // console.log(chapters);
    return {
      success: true,
      message: "Chapter Details",
      chapters
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}


