// app/books/create/actions.js
'use server';

import { createBook, updateBook, checkBookExistsByYear, checkBookExistsByYearExceptSelf } from '@/lib/services/bookService';

export async function createBookAction(payload) {
  try {
    const { book_title, book_year } = payload;


    // validation for existing book title based on year
    const isExist = await checkBookExistsByYear(book_title, book_year);

    if (isExist) {
      return {
        success: false,
        message: `The book "${book_title}" already exists in year ${book_year}.`,
      };
    }

    const books = await createBook(payload);

    return {
      success: true,
      message: "Book Created Successfully",
      books
    };
  } catch (error) {
    console.error("Error creating book details:", error);
    return {
      success: false,
      message: "Server error during book details"
    };
  }
}

export async function updateBookAction(bookId, payload) {
  try {
    const { book_title, book_year } = payload;

    // validation for existing book title based on year except self
    const isExist = await checkBookExistsByYearExceptSelf(book_title, book_year, bookId);

    if (isExist) {
      return {
        success: false,
        message: `The book "${book_title}" already exists in year ${book_year}.`,
      };
    }

    const books = await updateBook(bookId, payload);

    return {
      success: true,
      message: "Book updated Successfully",
      books
    };
  } catch (error) {
    console.error("Error updateing book details:", error);
    return {
      success: false,
      message: "Server error during book details"
    };
  }
}