// app/users/create/page.jsx
import Layout from "@/app/components/layout";
import CreateUserForm from "./CreateUserForm";
import { getUserById, getAllRoles } from "@/lib/services/userService";

export const dynamic = "force-dynamic";
export const fetchCache = "force-no-store";

export default async function CreateUserPage(props) {
  const searchParams = await props?.searchParams;
  const userId = searchParams?.id || null;

  const roles = await getAllRoles();
  let user = null;

  if (userId) {
    user = await getUserById(Number(userId));
  }

  return (
    <Layout>
      <CreateUserForm roles={roles} user={user} userId={userId} />
    </Layout>
  );
}
