import Layout from "@/app/components/layout";
import ChaptersPendingList from "./ChapterPendingList";
import { getAllUserPendingEntrys, getAllTasks } from '@/lib/services/entryService';
import { getAllBooks } from "@/lib/services/bookService";
import { getAllStaffUsers } from '@/lib/services/userService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function PendingEntryListPage() {
    const session = await getServerSession(authOptions);
    const userId = session?.user.user_pid;
    const chapterpendings = await getAllUserPendingEntrys(userId);
    const books = await getAllBooks();
    const tasks = await getAllTasks();
    const  users = await getAllStaffUsers(userId);
    // console.log(books);
    return (
        <Layout>
            <ChaptersPendingList
                initialPendings={chapterpendings}
                initialBooks={books}
                initialtasks={tasks}
                initialUsers={users}
            />
        </Layout>
    );
}