import Layout from "@/app/components/layout";
import UserPerformanceList from "./UserPerformanceList";
import { getAllUsersByRole } from '@/lib/services/userService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function UserPerformanceListPage() {
  
  const session = await getServerSession(authOptions);
  const user_role = session?.user.role;
  const users = await getAllUsersByRole(user_role);
  const username = users?.[0]?.user_pid;
  return (
    <Layout>
      <UserPerformanceList initialUsers={users} role = {user_role} username = {username} />
    </Layout>
  );
}
