import Layout from "@/app/components/layout";
import LogsList from "./LogList";
import { getLogsWithEntriesAndBreaks,getAllUsers } from '@/lib/services/userService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function LogsListPage() {
    const session = await getServerSession(authOptions);
    const userId = session?.user.user_pid;
    const userRole = session?.user.role;
    const  logs = await getLogsWithEntriesAndBreaks(userId, userRole);
     const  users = await getAllUsers();
    return (
        <Layout>
            <LogsList
             initialLogs={logs} 
             initialUsers={users} 
            />
        </Layout>
    );
}