import Layout from "@/app/components/layout";
import KnowledgesList from "./KnowledgeList";
import { getAllKnowledges } from '@/lib/services/knowledgeService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function KnowledgeListPage() {
     const session = await getServerSession(authOptions);
    const user_role = session?.user.role;
    const Knowledge = await getAllKnowledges();
    return (
        <Layout>
            <KnowledgesList
                initialKnowledges={Knowledge}
                role = {user_role}
            />
        </Layout>
    );
}