import Layout from "@/app/components/layout";
import HolidaysList from "./HolidayList";
import { getAllHolidays } from '@/lib/services/holidayService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function HolidayListPage() {
    const session = await getServerSession(authOptions);
    const user_role = session?.user.role;
    const holidays = await getAllHolidays();
    return (
        <Layout>
            <HolidaysList
                initialHolidays={holidays}
                role = {user_role}
            />
        </Layout>
    );
}