import Layout from "@/app/components/layout";
import BooksList from "./BookList";
import { getAllBooks } from '@/lib/services/bookService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
import { getAllChaptersByCE } from "@/lib/services/chapterService";
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function DashboardPage() {
    const session = await getServerSession(authOptions);
    const user_role = session?.user?.role;
    const books = await getAllBooks();
    // const bookIds = books.map(book => book.book_pid);
    const copyediting = await getAllChaptersByCE();
  return (
    <Layout>
      <BooksList 
      initialBooks={books} 
      initialCopyediting={copyediting}
      role = {user_role}
      />
    </Layout>
  );
}
