'use client';

import { Tooltip } from "react-tooltip";
import { FiDownload } from 'react-icons/fi';


const stageMap = {
    FC: 'First Check',
    FCR: 'First Check Resubmit',
    FCQC: 'First Check QC',
    EDA: 'Editor Assignment',
    PR: 'Peer Review',
    MD: 'Make Decision',
    RC: 'Revision Check',
    CE: 'Copy Editing',
};

export const getCopyeditingColumns = () => [
    {
        label: 'S.No',
        name: 'S.No',
        cell: (_row, index) => index + 1,
    },
    {
        label: 'Book Title',
        name: 'Book Title',
        selector: (row) => row.book.book_title,
    },
    //  {
    //     label: 'Book Year',
    //     name: 'Book Year',
    //     selector: (row) => row.book.book_year,
    // },
    {
        label: 'Chapter Title',
        name: 'Chapter Title',
        selector: (row) => row.chap_title,
    },
    {
        label: 'Manuscript\u00A0ID',
        name: 'Chapter Title',
        selector: (row) => row.chap_manuscriptID,
    },
    {
        label: 'Chapter Status',
        name: 'Chapter Status',
        selector: (row) => stageMap[row?.chap_currentStage] || row?.chap_currentStage || '-',
    },
    {
        label: "CE Status",
        name: "CE Status",
        cell: (row) => {
            const ce = row.ce_editing?.[0];

            const statusMap = {
                1: {
                    label: "Sent",
                    color: "bg-blue-100 text-blue-700 border-blue-300",
                    date: ce?.ce_sent_date,
                    tooltip: "Sent Date",
                    comment: ce?.ce_sent_comments,
                    commentLabel: "Send Comments",
                    file: ce?.ce_sent_file ? `/CE/Send_Files/${ce.ce_sent_file}` : null,
                },
                2: {
                    label: "Accepted",
                    color: "bg-green-100 text-green-700 border-green-300",
                    date: ce?.ce_accept_date,
                    tooltip: "Accepted Date",
                },
                3: {
                    label: "Rejected",
                    color: "bg-red-100 text-red-700 border-red-300",
                    date: ce?.ce_reject_date,
                    tooltip: "Rejected Date",
                },
                4: {
                    label: "Timeout",
                    color: "bg-amber-100 text-amber-700 border-amber-300",
                    date: ce?.ce_timeout_date,
                    tooltip: "Timeout Date",
                    sendDate: ce?.ce_sent_date,
                    ceEditorName: ce?.user?.user_name,
                },
                5: {
                    label: "Received",
                    color: "bg-purple-100 text-purple-700 border-purple-300",
                    date: ce?.ce_received_date,
                    tooltip: "Received Date",
                    comment: ce?.ce_received_note,
                    commentLabel: "Received Comments",
                    file: ce?.ce_received_file ? `/CE/Recieve_Files/${ce.ce_received_file}` : null,
                },
            };

            const status = ce?.ce_status;
            const info = statusMap[status];
            if (!info) return <span className="text-gray-500">-</span>;

            const tooltipId = `status-tooltip-${row.chap_pid}`;
            let tooltipContent = `${info.tooltip}: ${info.date || "Not available"}`;

            if (info.comment)
                tooltipContent += `\n${info.commentLabel}: ${info.comment}`;

            if (status === 4) {
                if (info.sendDate) tooltipContent += `\nSend Date: ${info.sendDate}`;
                if (info.ceEditorName)
                    tooltipContent += `\nEditor Name: ${info.ceEditorName}`;
            }

            return (
                <div className="flex items-center gap-2">
                    <span
                        data-tooltip-id={tooltipId}
                        data-tooltip-content={tooltipContent}
                        className={`inline-flex items-center px-2 py-1 text-xs font-medium border rounded-full cursor-pointer ${info.color}`}
                    >
                        {info.label}
                    </span>

                    {info.file && (
                        <a
                            href={info.file}
                            download
                            target="_blank"
                            rel="noopener noreferrer"
                            className="text-blue-500 hover:text-blue-700"
                            title={`Download ${info.label} File`}
                        >
                            <FiDownload size={14} />
                        </a>
                    )}

                    <Tooltip
                        id={tooltipId}
                        place="bottom"
                        style={{
                            backgroundColor: "#1E293B",
                            color: "#fff",
                            fontSize: "12px",
                            borderRadius: "6px",
                            padding: "6px 10px",
                            whiteSpace: "pre-line",
                            lineHeight: "1.4",
                            maxWidth: "250px",
                             zIndex: "1000",
                        }}
                    />
                </div>
            );
        },
        grow: 2,
        wrap: true,
    },
    {
        label: "Editor Name",
        name: "Editor Name",
        cell: (row) => (
            <strong>{row.ce_editing[0].user.user_name}</strong>
        ),
    },
    {
        label: "Send Date",
        name: "Send Date",
        selector: (row) => row.ce_editing[0].ce_sent_date,
    },
    {
        label: "Due Date",
        name: "Due Date",
        selector: (row) => row.ce_editing[0].ce_due_date,
    },
    // {
    //     label: "Send File",
    //     name: "Send File",
    //     cell: (row) => row.ce_editing[0].ce_sent_file ? (<a href={`/CE/Send_Files/${row.ce_editing[0].ce_sent_file}`} download target="_blank" title="Download File" > <FaDownload style={{ color: "#007bff", fontSize: "1.1rem" }} /> </a>) : (<span style={{ color: "gray" }}>No File</span>),
    // },
    {
        label: "Received Date",
        name: "Received Date",
        selector: (row) => {
            if (!row.ce_editing[0].ce_received_date) return "";
            const date = new Date(row.ce_editing[0].ce_received_date);
            return date.toISOString().split("T")[0];
        },
    },
    // {
    //     label: "Received File",
    //     name: "Received File",
    //     cell: (row) => row.ce_editing[0].ce_received_file ? (<a href={`/CE/Recieve_Files/${row.ce_editing[0].ce_received_file}`} download target="_blank" title="Download File" > <FaDownload style={{ color: "#007bff", fontSize: "1.1rem" }} /> </a>) : (<span style={{ color: "gray" }}>No File</span>),
    // },
    // {
    //   label: "Comments",
    //   name: "Comments",
    //   selector: (row) => row.chapters[0].chap_comments,
    //   grow: 2,
    //   wrap: true,
    // },
];
