'use client';


export const getBookColumns = () => [
  {
    label: 'S.No',
    name: 'S.No',
    cell: (_row, index) => index + 1,
  },
  {
    label: 'Working Title',
    name: 'Working Title',
    selector: (row) => row.book_year,
  },
  {
    label: 'Book Title',
    name: 'Book Title',
    selector: (row) => row.book_title,
  },
  {
    label: 'Lead\u00A0Editor Name',
    name: 'Lead\u00A0Editor Name',
    selector: (row) => row.book_LeadEditorName,
  },
  {
    label: 'Book ID',
    name: 'Book ID',
    cell: (row) => {
      return (
        <div className="flex items-center justify-center px-3 py-1 rounded-full bg-red-100 text-red-600 cursor-pointer hover:bg-red-200 hover:text-red-800 transition">
          {row.book_CustomId}
        </div>
      );
    },
    styleTypeUiPatterns: 'badge',
    styleTypeColors: 'dark',
  },
  {
    label: 'Online ISBN',
    name: 'Online ISBN',
    selector: (row) => row.book_OnlineIsbn,
  },
  {
    label: 'AU\u00A0Inv\u00A0Sent Date',
    name: 'AU\u00A0Inv\u00A0Sent Date',
    selector: (row) => row.book_AuthorInvitationsSent,
  },
  {
    label: 'AU Invited',
    name: 'AU Invited',
    selector: (row) => row.book_AuInvited,
  },
  {
    label: 'AU Accepted',
    name: 'AU Accepted',
    selector: (row) => row.book_AuAccepted,
  },
  {
    label: 'CH.\u00A0Due Date',
    name: 'CH.\u00A0Due Date',
    selector: (row) => row.book_ChapDueDate,
  },
  {
    label: 'Drop\u00A0Dead Date',
    name: 'Drop\u00A0Dead Date',
    selector: (row) => row.book_DropDeadDate,
  },
  {
    label: 'CH Submitted',
    name: 'CH Submitted',
    selector: (row) => row.book_ChSubmitted,
  },
  {
    label: 'CH Accepted',
    name: 'CH Accepted',
    selector: (row) => row.book_ChAccepted,
  },
  {
    label: 'Last\u00A0CH Due\u00A0to\u00A0Prod.',
    name: 'Last CH Due to Prod.',
    selector: (row) => row.book_LastDueProduction,
  },
  {
    label: 'Project Manager',
    name: 'Project Manager',
    selector: (row) => row.book_ProjectManager,
    // styleTypeColors: 'text_secondary',
  },
  {
    label: 'Note/Comments',
    name: 'Note/Comments',
    selector: (row) => row.book_NoteComments,
    // styleTypeColors: 'text_info',
  },
];
