"use client";

import { useEffect, useMemo, useState } from "react";
import { useRouter } from "next/navigation";
import CustomDataTable from "../../dataTable/customDataTable";
import { getCopyeditingColumns  } from "./columns";
import Select from "react-select";
import selectStyles from "@/app/components/selectStyles";

export default function CopyEditingList({ initialBooks, initialCopyediting, initialCeEditingDetails }) {
  const [data, setData] = useState(initialCeEditingDetails || []);
  const [loading, setLoading] = useState(true);
  const [filteredData, setFilteredData] = useState([]);
  const [selectedBook, setSelectedBook] = useState(null);
  const router = useRouter();

  useEffect(() => {
    setData(initialCeEditingDetails || []);
    setFilteredData(initialCeEditingDetails || []);
    console.log("Copyediting Data:+++++++++++++++++++++++++++", initialCeEditingDetails);
    setLoading(false);
  }, [initialCeEditingDetails]);

  const bookOptions = initialBooks.map((b) => ({
    value: String(b.book_pid),
    label: b.book_title.charAt(0).toUpperCase() + b.book_title.slice(1),
  }));

  const columns = useMemo(() => getCopyeditingColumns(), []);


  return (
    <div className="max-w-full px-2 py-2 mx-auto rounded-lg  space-y-4">
      <header className="mb-6">
         <h1 className="text-3xl font-extrabold text-gray-900" >Copy Editing Dashboard</h1>
      </header>
      <div className="bg-purple-50 border border-purple-200 rounded-lg p-2 shadow-sm">
        <div className="flex flex-wrap gap-4 items-center justify-start">
          <div className="flex flex-col">
            <label className="text-xs text-gray-600 font-semibold mb-1">
              Book Title
            </label>
            <Select
              instanceId="book-filter"
              options={bookOptions}
              value={selectedBook}
              onChange={setSelectedBook}
              placeholder="Select Book Title"
              isClearable
              className="w-33 text-sm"
              menuPortalTarget={document.body}
              styles={selectStyles}
            />
          </div>
          
          {/* Clear Filters Button */}
          <div className="pt-5">
            <button
              onClick={() => {
                setSelectedBook(null);
              }}
              className="text-sm px-4 py-2 bg-purple-100 hover:bg-purple-200 text-purple-700 rounded transition-all duration-200 cursor-pointer"
            >
              Clear Filter
            </button>
          </div>
        </div>
      </div>
      <CustomDataTable
        columns={columns}
        data={filteredData}
        progressPending={loading}
        defaultSort={{ key: "Working Title", direction: "ascending" }}
      />
    </div>
  );
}