// columns.js
import { FiEdit, FiTrash2, FiEye } from "react-icons/fi";
import { Tooltip } from "react-tooltip";
export const getChapterColumns = (router, handleDelete, combinedChapter, role) => {
  const Role = Number(role);
  const stageLabels = {
    FC: "First Check",
    FCR: "First Check Resubmit",
    FCQC: "First Check QC",
    FCRQC: "First Check Resubmit QC",
    EDA: "Editor Assignment",
    PR: "Peer Review",
    MD: "Make Decision",
    RCER: "Revision Check Editor Recommendation",
  };
  const columns = [
    {
      label: "S.No",
      name: "S.No",
      cell: (row, index) => index + 1,
      // width: "60px",
    },
    {
      label: "Book Title",
      name: "Book Title",
      selector: (row) => row.book.book_title,
      // styleTypeUiPatterns: 'badge',
      // styleTypeColors: 'dark',
    },
    {
      label: "Manuscript\u00A0ID",
      name: "Manuscript\u00A0ID",
      selector: (row) => row.chap_manuscriptID,
      // styleTypeUiPatterns: 'badge',
      // styleTypeColors: 'info',
    },
    {
      label: "Chapter Title",
      name: "Chapter Title",
      selector: (row) => row.chap_title,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Word Count",
      name: "Word Count",
      selector: (row) => row.chap_wordcount,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Author",
      name: "Author",
      cell: (row) => `${row.chap_firstName} ${row.chap_lastName}`,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Email",
      name: "Email",
      selector: (row) => row.chap_corresAuEmail,
      // styleTypeUiPatterns: 'badge',
      // styleTypeIcons: 'mailIcon',
      // styleTypeColors: 'info',
    },
    {
      label: "Stage",
      name: "Stage",
      //selector: (row) => row.chap_currentStage,
      selector: (row) => stageLabels[row.chap_currentStage] || row.chap_currentStage,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "P+ Status",
      name: "P+ Status",
      selector: (row) => row.pstatus?.pstatus_name || "",
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Due Date",
      name: "Due Date",
      selector: (row) => row.chap_pdueDate,
      styleTypeUiPatterns: "badge",
    },
    {
      label: "Copy Editing",
      name: "Copy Editing",
      selector: (row) => row.chap_copyEditing,
      styleTypeUiPatterns: "badge",
      styleTypeColors: "warning",
    },
    {
      label: "Comments",
      name: "Comments",
      selector: (row) => row.chap_comments,
      grow: 2,
      wrap: true,
    },
    {
      label: "Updated By",
      name: "Updated By",
      selector: (row) => row.user?.user_name || "",
    },
    {
      label: "Action",
      name: "Action",
      cell: (row) => (
        <div className="flex space-x-3">
          {/* Edit */}
          <button
            onClick={() => router.push(`/chapters/create?id=${row.chap_pid}`)}
            data-tooltip-id={`edit-tooltip-${row.chap_pid}`}
            data-tooltip-content="Edit"
            className="text-blue-600 hover:text-blue-800 cursor-pointer"
            type="button"
          >
            <FiEdit size={20} />
            <Tooltip
              id={`edit-tooltip-${row.chap_pid}`}
              place="top"
              style={{
                backgroundColor: "#3b82f6",
                color: "#fff",
                fontSize: "12px",
                borderRadius: "4px",
                padding: "6px 10px",
                zIndex: "1000",
              }}
            />
          </button>
          <button
            onClick={() => router.push(`/chapterDetails?id=${row.chap_pid}`)}
            data-tooltip-id={`view-tooltip-${row.chap_pid}`}
            data-tooltip-content="View"
            className="text-yellow-600 hover:text-yellow-800 cursor-pointer"
            type="button"
          >
            <FiEye size={20} />
            <Tooltip
              id={`view-tooltip-${row.chap_pid}`}
              place="top"
              style={{
                backgroundColor: "#e8f809fd",
                color: "#fff",
                fontSize: "12px",
                borderRadius: "4px",
                padding: "6px 10px",
                zIndex: "1000",
              }}
            />
          </button>


          {combinedChapter.some(entry => entry.id === row.chap_pid && entry.value === 0 && Role !== 3) && (
            <button
              onClick={() => handleDelete(row.chap_pid, row.chap_title)}
              data-tooltip-id={`delete-tooltip-${row.chap_pid}`}
              data-tooltip-content="Delete"
              className="text-red-600 hover:text-red-800 cursor-pointer"
              type="button"
            >
              <FiTrash2 size={20} />
              <Tooltip
                id={`delete-tooltip-${row.chap_pid}`}
                place="top"
                style={{
                  backgroundColor: "#ef4444",
                  color: "#fff",
                  fontSize: "12px",
                  borderRadius: "4px",
                  padding: "6px 10px",
                  zIndex: "1000",
                }}
              />
            </button>
          )}
        </div>
      ),
      ignoreRowClick: true,
    },
  ];
  return columns;
};
