// app/chapters/create/page.jsx
import Layout from "@/app/components/layout";
import CreateChapterForm from "./CreateChapterForm";
import { getAllBooks } from "@/lib/services/bookService";
import { getAllPStatus, getChapterById } from "@/lib/services/chapterService";
import { notFound } from "next/navigation";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic";

export default async function CreateChapterPage( props ) {
     const session = await getServerSession(authOptions);
    const user_pid = session?.user.user_pid;
    // const chapterId = await searchParams.id;
    const params =  await props?.searchParams;
    const chapterId = params.id;
    // Fetch books + pstatus server-side
    const [books, pstatus, chapter] = await Promise.all([
        getAllBooks(),
        getAllPStatus(),
        chapterId ? getChapterById(chapterId) : null,
    ]);

    if (chapterId && !chapter) {
        notFound();
    }

    return (
        <Layout>
            <CreateChapterForm
                initialBooks={books}
                initialPStatus={pstatus}
                chapter={chapter}
                chapterId={chapterId}
                user_pid = {user_pid}
            />
        </Layout>
    );
}
