// columns.js
import { FiEdit, FiTrash2, FiEye } from "react-icons/fi";
import { Tooltip } from "react-tooltip";
export const getChapterDetailsColumns = (router, role, bookData,chapterData) => {
  const Role = Number(role);
  const formatDate = (dateString) => {
    const date = new Date(dateString);
    if (isNaN(date)) return "-"; // handle invalid date
    const mm = String(date.getMonth() + 1).padStart(2, "0");
    const dd = String(date.getDate()).padStart(2, "0");
    const yyyy = date.getFullYear();
    return `${dd}-${mm}-${yyyy}`;
  };
  const columns = [
    {
      label: "S.No",
      name: "S.No",
      cell: (row, index) => index + 1,
      // width: "60px",
    },
    {
      label: "Book Title",
      name: "Book Title",
      selector: () => bookData ? bookData.book_title : "-",
    },
    {
      label: "Chapter Title",
      name: "Chapter Title",
      selector: () => chapterData ? chapterData.chap_title : "-",
    },
    {
      label: "Stage From",
      name: "Stage From",
      selector: (row) => row?.stage_from,
    },
    {
      label: "Stage To",
      name: "Stage To",
      selector: (row) => row?.stage_to,
    },
    {
      label: "Stage Notes",
      name: "Stage Notes",
      selector: (row) => row?.stage_notes,
    },
    {
      label: "Stage Upload File",
      name: "Stage Upload File",
      selector: (row) => row?.stage_uploadFile,
    },
    {
      label: "Dispatch Date",
      name: "Dispatch Date",
      selector: (row) => formatDate(row?.stage_dispachDate),
    },
    {
      label: "Status",
      name: "Status",
      selector: (row) => row?.status?.status_name,
    },
    

  ];
  return columns;
};
