"use client";

import React, { useEffect, useMemo, useState } from 'react';
import { BookOpen, Clock, CheckCircle, TrendingUp, Calendar, FileText, Eye } from 'lucide-react';
import { useRouter } from "next/navigation";
import CustomDataTable from '../dataTable/customDataTable';
import { getChapterDetailsColumns } from './columns';
export default function ViewChapterDetails(initialChapter,chapterId,user_pid,role){
    const [data, setData] = useState(initialChapter || []);
    const [loading, setLoading] = useState(true);
    const router = useRouter();

    useEffect(() => {
    setData(initialChapter || []);
    setLoading(false);
    }, [initialChapter]);

    const chapterData = data.initialChapter[0];
    const bookData = data.initialChapter[0]?.book;
    const stageMovementData = data.initialChapter[0]?.stage_movements;
    console.log(chapterData,"chapterDataNew");
    console.log(bookData,"bookData");
    console.log(stageMovementData,"stageMovementData");

  
  const formatDate = (dateString) => {
    const date = new Date(dateString);
    if (isNaN(date)) return "-"; // handle invalid date
    const mm = String(date.getMonth() + 1).padStart(2, "0");
    const dd = String(date.getDate()).padStart(2, "0");
    const yyyy = date.getFullYear();
    return `${dd}-${mm}-${yyyy}`;
  };
   const columns = useMemo(() => getChapterDetailsColumns(router, role, bookData,chapterData), [router, role, bookData,chapterData]);

  return (
    <div className="min-h-screen bg-gray-50">
        {/* Header - No Background Color */}
        <section className="py-8 border-b border-gray-200">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="flex items-center justify-between">
                <div>
                <h1 className="text-4xl font-bold text-gray-900 mb-2">
                    {bookData?.book_title} : {chapterData.chap_title}
                </h1>
                </div>
            </div>
            </div>
        </section>

        {/* Book Details - Label & Data Format */}
        <section className="py-12 bg-white">
            <div className="max-w-7xl mx-auto px-6 sm:px-6 lg:px-8">
                <h2 className="text-2xl font-bold text-gray-900 mb-6 flex items-center gap-2">
                    <BookOpen className="w-6 h-6 text-blue-600" /> Book Information
                </h2>
                {/* Reduced gap from gap-6 → gap-3 */}
                <div className="grid md:grid-cols-2 lg:grid-cols-2 gap-3">
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Book Year Title :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.book_year}</p>
                        </div>
                    </div>
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Book Name :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.book_title}</p>
                        </div>
                    </div>

                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Lead Editor :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.book_LeadEditorName}</p>
                        </div>
                    </div>
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Customer ID :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.book_CustomId}</p>
                        </div>
                    </div>
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            ISBN :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.book_OnlineIsbn}</p>
                        </div>
                    </div>
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Book Notes :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.book_NoteComments}</p>
                        </div>
                    </div> 
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Project Manager :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{bookData?.pm_user?.user_name}</p>
                        </div>
                    </div>
                    <div className="bg-white p-4 rounded-xl border border-gray-200 shadow-sm">
                        <div className="flex items-center gap-3">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide">
                            Book Create Date :
                        </label>
                        <p className="text-lg font-medium text-gray-900">{formatDate(bookData?.book_createdAt)}</p>
                        </div>
                    </div> 
                </div>
            </div>
        </section>

        
        {/* Chapter Details - Label & Data Format */}
        <section className="py-12 bg-gray-50">
            <div className="max-w-7xl mx-auto px-6 sm:px-6 lg:px-8">
                <h2 className="text-2xl font-bold text-gray-900 mb-12 flex items-center gap-2">
                    <FileText className="w-6 h-6 text-purple-600" />
                    Chapter Details
                </h2>

                <div className="grid md:grid-cols-[45%_2px_1fr] gap-0">
            
                    {/* Chapter Title */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Chapter Title 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_title}</p>
                    </div>

                    {/* Manuscript ID */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Manuscript ID 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_manuscriptID}</p>
                    </div>

                    {/* First Name */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            First Name 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_firstName}</p>
                    </div>

                    {/* Last Name */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Last Name 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_lastName}</p>
                    </div>

                    {/* Author Email */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Author Email 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900 break-words">
                            {chapterData?.chap_correspondingAuthorEmail || "-"}
                        </p>
                    </div>

                    {/* Status */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Status 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.pstatus}</p>
                    </div>

                    {/* P+ Status */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            P+ Status 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_pStatus}</p>
                    </div>

                    {/* P+ Due Date */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            P+ Due Date 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_pdueDate || "-"}</p>
                    </div>

                    {/* Current Stage */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Current Stage 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_currentStage}</p>
                    </div>

                    {/* Word Count */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Word Count 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_wordcount || "-"}</p>
                    </div>

                    {/* Pre Word Count */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Pre Word Count 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_pre_wordcount || "-"}</p>
                    </div>

                    {/* Copy Editing */}
                    <div className="pr-6 py-3 border-b border-gray-200">
                        <label className="text-sm font-semibold text-gray-600 uppercase tracking-wide float-right">
                            Copy Editing 
                        </label>
                    </div>
                    <div className="bg-gray-300"></div>
                    <div className="pl-6 py-3 border-b border-gray-200">
                        <p className="text-lg font-medium text-gray-900">{chapterData?.chap_copyEditingStatus || "-"}</p>
                    </div>
                </div>
            </div>
        </section>

        {/* Stage Movement - Grid Format */}
        <section className="py-12 bg-white">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="mb-8">
                    <h2 className="text-2xl font-bold text-gray-900 mb-2 flex items-center gap-2">
                    <TrendingUp className="w-6 h-6 text-purple-600" />
                    Stage Movement
                    </h2>
                </div>

                <CustomDataTable
                    columns={columns}
                    data={stageMovementData}
                    progressPending={loading}
                    defaultSort={{ key: "Working Title", direction: "ascending" }}
                />
            </div>
        </section>
    </div>
  );
}

