import Layout from "@/app/components/layout";
import BreaksList from "./BreakList";
import { getAllBreaks,getAllUsers } from '@/lib/services/userService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function BreaksListPage() {
    const session = await getServerSession(authOptions);
    const userId = session?.user.user_pid;
    const userRole = session?.user.role;
    const  breaks = await getAllBreaks(userId, userRole);
     const  users = await getAllUsers();
    return (
        <Layout>
            <BreaksList
             initialBreaks={breaks} 
             initialUsers={users} 
            />
        </Layout>
    );
}