import Layout from "@/app/components/layout";
import BooksList from "./BookList";
import { getAllBooks, getAllBookYear } from '@/lib/services/bookService';
import { getBookEntryId } from '@/lib/services/entryService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function BooksListPage() {
    const books = await getAllBooks();
    const book_year = await getAllBookYear();
    
    const session = await getServerSession(authOptions);
    const user_role = session?.user.role;
    const bookEntriesPromises = books.map(async (book) => {
        const bookId = book.book_pid;
        const bookEntries = await getBookEntryId(bookId);
        return bookEntries;
    });

    const allEntriesResults = await Promise.all(bookEntriesPromises);
    const flatBookEntries = allEntriesResults.flat(); 
    return (
        <Layout>
            <BooksList
                initialBooks={books}
                initialBookYears={book_year}
                initialBookEntries={flatBookEntries} 
                initialBookId={books.map(book => book.book_pid)}
                role = {user_role}
            />
        </Layout>
    );
}