<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<style type="text/css">
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
tr td.no_more_rows
{
	text-align:center;
	box-sizing: content-box;    
	border: 1px solid #dee2e6;
	padding: 0.75rem;
	vertical-align: top;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of Articles - Issue wise</strong> </h3>
          </div>  
        </div>
        <div class="card-body table-responsive">
          <div class="row">
            <div class="col-md-3"></div>
            <div class="col-md-4">
              <select name="value" id='sel_city' class="form-control">
                <option value=''>-- Select Issue --</option>
                <?php 
                foreach($issues as $issue){
                  echo "<option value='".$issue."'>".$issue."</option>";
                }
                ?>
              </select>
            </div>
          </div><br>
          <table id="example2" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>ISSUE NAME</th>
            <th>ARTICLE NO.</th>
            <!-- <th>DUEDATE</th>
            <th>CURRENT STAGE</th> -->
            <th>PUBLISHED DATE</th>
            <th>PDF PAGE</th>
            <th>FIRST PAGE</th>
            <th>LAST PAGE</th>
            <th>DOI</th>
            <th>STATUS</th>           
          </tr>
          </thead>
          <tbody>
		  <?php if(count($article_detail) > 0) {?>
            <?php $s_no = 1; foreach($article_detail as $data): //echo "<pre>"; print_r($data); ?>
            <tr>
              <td><?= $s_no ?></td>
              <!-- <td class="serial"></td> -->
              <td><?= $data['issue_name']; ?></td>
              <td><a href="<?= base_url('admin/articles/view/'.$data['j_id']); ?>"><?= $data['article_no']; ?></a></td>
<?php /*
              <?php
              $today = date('Y-m-d');
              $due_date = date('d-m-Y',strtotime($data['due_date']));
              if ($data['due_date'] < $today) {
                ?><td style="background:red; color: white; font-weight: 700;"><?= $due_date; ?></td>
              <?php }
              else{ ?>
                <td><?= $due_date; ?></td>
              <?php
              }
              ?> */?>
            <!--  <td><?= $data['ms_word'] ?></td>
              <td><?= $data['supp'] ?></td>
              <td><?= $data['nof'] ?></td>
              <td><?= $data['not1'] ?></td> 
              <td><?php  $data['due_date'];  echo date('d-m-Y',strtotime($data['due_date']));?></td>
             <td><?= $data['article_type'] ?></td>
              <td><?= $data['remarks_article'] ?></td>-->

              <td><?= $data['published_date'] ?></td>
              <td><?= $data['pdf_pages'] ?></td>
              <td><?= $data['first_page'] ?></td>
              <td><?= $data['last_page'] ?></td>
              <td><?= $data['doi_number'] ?></td>
              
              <td><?= $data['status'] ?></td>
            </tr>
            <?php $s_no++; endforeach; ?>
			<?php } else {?>
			<tr><td colspan="7" class="no_more_rows">No data available in table</td></tr>
			<?php } ?>
          </tbody>
          </table>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Send to Copyeditor-->
    <form action="articles/updateSentToCe" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Send to Copyeditor</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status" value="Copyediting" >
                    <input type="hidden" class="duedate" name="duedate" value="" >
                    <input type="date" class="form-control senttoce" name="senttoce" value="" >
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Priority-->
    <!-- Modal Send to Copyeditor-->
    <form action="articles/updatepriority" method="post">
        <div class="modal fade" id="editModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Priority</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Priority</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="text" class="form-control priority" name="priority" value="" >
                </div>             
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Priority-->

<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>

<script>
  $("#invoices").addClass('active');
</script>
<script>
  document.getElementById("copyeditor").onclick = function() {
    //disable
    this.disabled = true;

    //do some validation stuff
}
</script>
<script src="/js/jquery.min.js"></script>
<script src="/js/bootstrap.bundle.min.js"></script>
<script>
    $(document).ready(function(){
 
        // get Edit Send to CE
        $('.btn-edit').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            const senttoce = $(this).data('senttoce');
            const status = $(this).data('status');
            const duedate = $(this).data('duedate');
            // Set data to Form Edit
            $('.id').val(id);
            $('.senttoce').val(senttoce);
            $('.status').val(status);
            $('.duedate').val(duedate);
            
            // Call Modal Edit
            $('#editModal').modal('show');
            
        });

        // get Edit Priority
        $('.btn-edit1').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            const priority = $(this).data('priority');

            // Set data to Form Edit
            $('.id').val(id);
            $('.priority').val(priority);
        
            // Call Modal Edit
            $('#editModal1').modal('show');
            
        });
 
        // get Delete Product
        $('.btn-delete').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            // Set data to Form Edit
            $('.productID').val(id);
            // Call Modal Edit
            $('#deleteModal').modal('show');
        });
         
    });
</script>
<script>
var url = "<?= base_url('admin/reports/issuewisefilter')?>";
var value = "";
$(document).ready(function(){
    $("select").change(function(){
        value = $(this).val();
        window.location.href = url+'/'+value;
    });
});
</script>
<style>
.dt-buttons
{
	 text-align: right !important;
	 padding-bottom:1%;
}
.dt-button
{
	color: #ffffff !important;
    background-color: #28a745 !important;
    border-color: #28a745 !important;
    box-shadow: 0 1px 1px rgb(0 0 0 / 8%) !important;
    padding: 0.5% 2% 0.5% 2% !important;
	cursor: pointer !important;
	display: inline-block !important;
    font-weight: 400 !important;
    text-align: center !important;
    white-space: nowrap !important;
    vertical-align: middle !important;
    user-select: none !important;
    border: 1px solid transparent !important;
    padding: 0.375rem 0.75rem !important;
    font-size: 1rem !important;
    line-height: 1.5 !important;
    border-radius: 0.25rem !important;
    transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out !important;
}
</style>
<script src="https://cdn.datatables.net/buttons/1.6.5/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.print.min.js"></script>
<script>
$(document).ready(function() 
{
    $('#example2').DataTable({
		"paging": true,
		"lengthChange": true,
		"searching": true,
		"ordering": true,
		"info": true,
		"autoWidth": true,
		dom: 'Bfrtip',
    buttons: ['excel']
		//buttons: ['excel', 'pdf', 'print']
    });
});
</script>