<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<style type="text/css">
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
tr td.no_more_rows
{
	text-align:center;
	box-sizing: content-box;    
	border: 1px solid #dee2e6;
	padding: 0.75rem;
	vertical-align: top;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of Articles in PE Revises</h3>
          </div>
          
        </div>
        <div class="card-body table-responsive">
          <table id="example2" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>JOURNAL NAME</th>
            <th>ARTICLE NO.</th>
            <th>PDF PAGES</th>
            <th>SENT PDF TO PE</th>
            <th>EXPECTED FROM PE</th>
            <th>RECEIVED PDF FROM PE</th>
            <th>APPROVE</th>
			<th>STATUS</th>
			<th>STAGE</th>
            <th>PE REMARKS</th>
			<th>PRIORITY</th>
			<th>EMAIL</th>
			<?php if($this->session->userdata('admin_role') == "Super Admin" || $this->session->userdata('admin_role') == "User"){?>
            <th>ACTION</th> 
			<?php } ?>
          </tr>
          </thead>
          <tbody>
		   <?php if(count($article_detail) > 0) {?>
            <?php $s_no = 1; foreach($article_detail as $data): ?>
            <?php
				$today = date('Y-m-d');
				$due_date = date('d-m-Y',strtotime($data['exp_from_pe']));
				
			if ($data['exp_from_pe'] != '0000-00-00' && $data['exp_from_pe'] < $today) {
			?>
            <tr style="color: red !important; font-weight: 700;">
			<?php } else if($data['priority'] == '1'){?>
			<tr style="color: green !important; font-weight: 700;">
			<?php } else { ?>
			<tr>
			<?php } ?>
			<?php
				
				$pe_revises_selection = $this->db->select('*')
											->from('pe_revises')
											->where('article_no', $data['article_no'])
											->where('current_stage', 'PE Revises')
											->get()
											->result_array();
				if(count($pe_revises_selection) > 0)
				{
					$revises_stage = 'PE&#x00A0;Revises&#x00A0;'.count($pe_revises_selection);
				}
				else
				{
					$revises_stage = '-';
				}
				
				
				?>
			
			
              <td class="serial"></td>
              <td><?= $data['journal_name']; ?></td>
              <td><?= $data['article_no']; ?></td>
              <td><?= $data['pdf_pages']; ?></td>
              <td>
                <?php
                  if ($data['status'] != 'PE') {
                  if ($data['sent_pdf_to_pe'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit1" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_pdf_to_pe']?>" value="<?= $data['sent_pdf_to_pe']?>" data-articleno="<?= $data['article_no']?>"><strong><?= date('d-m-Y',strtotime($data['sent_pdf_to_pe'])); ?></strong></a>
                  <?php }
                  else{ ?>
                    <a href="#" class="btn-edit1" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_pdf_to_pe']?>" data-articleno="<?= $data['article_no']?>"><strong>Send</strong></a>
                 <?php }
             }
                 else{
                    if ($data['sent_pdf_to_pe'] != '0000-00-00') { ?>
                    <strong><?= date('d-m-Y',strtotime($data['sent_pdf_to_pe'])); ?></strong>
                  <?php }
                  else{ ?>
                    <strong>---</strong>
                 <?php }
             }
                ?>
              </td>
               <td><?= $due_date; ?></td>   
              <td><?php
			   if($this->session->userdata('admin_role') == "Super Admin")
				{ 
					if ($data['status'] == 'PE') {
					if ($data['received_from_pe'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit2" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-pdfsenttope="<?= $data['sent_pdf_to_pe']?>" data-articleno="<?= $data['article_no']?>"><strong><?= date('d-m-Y',strtotime($data['received_from_pe']))?></strong></a>
					<?php }
					else{ ?>
                    <a href="#" class="btn-edit2" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-pdfsenttope="<?= $data['sent_pdf_to_pe']?>" data-articleno="<?= $data['article_no']?>"><strong>Update</strong></a>
					<?php }
					}
					else
					{
					  if ($data['received_from_pe'] != '0000-00-00') { ?>
						<strong><?= date('d-m-Y',strtotime($data['received_from_pe']))?></strong>
					  <?php }
					  else{ ?>
						<strong>---</strong>
					 <?php }
					}
				}
				else if($this->session->userdata('admin_role') == "User")
				{
					if ($data['status'] == 'PE') {
					if ($data['received_from_pe'] != '0000-00-00') { ?>
                    <strong><?= date('d-m-Y',strtotime($data['received_from_pe']))?></strong>
					<?php }
					}
					else
					{
					  if ($data['received_from_pe'] != '0000-00-00') { ?>
						<strong><?= date('d-m-Y',strtotime($data['received_from_pe']))?></strong>
					  <?php }
					  else{ ?>
						<strong>---</strong>
					 <?php }
					}
				}
                ?></td>
              <td><?php
              if ($data['status'] == 'Production') {
                  if ($data['approved_date'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['approved_date']?>" data-articleno="<?= $data['article_no']?>"><strong><?= date('d-m-Y',strtotime($data['approved_date']))?></strong></a>
                  <?php }
                  else{ ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['approved_date']?>" data-articleno="<?= $data['article_no']?>"><strong>Send</strong></a>
                 <?php }
             }
             else{
                  if ($data['approved_date'] != '0000-00-00') { ?>
                    <strong><?= date('d-m-Y',strtotime($data['approved_date']))?></strong>
                  <?php }
                  else{ ?>
                    <strong>---</strong>
                 <?php }
             }
                ?></td>
				
              <td><?= $data['status']; ?></td>
			  <td><?php echo $revises_stage ?></td>
              <td><?= $data['remarks_pe']; ?></td>
			  <td style="text-align:center;">
				<?php
				if($data['priority'] == 1)
				{?>
					<a href="#" class="btn-edit3" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">
					<img width="25" title="High" src="<?= base_url('assets/dist/img/high_priority.png'); ?>"/>
					</a>
				<?php } else {?>
					<a href="#" class="btn-edit3" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">
					<img width="25" title="Regular" src="<?= base_url('assets/dist/img/regular_priority.png'); ?>"/>
					</a>
				<?php } ?>
				
				</td>
			  <td style="text-align:center;"><a href="#" class="btn-edit5 btn btn-success" data-id="<?= $data['id']?>" onclick="getting_values('<?php echo $data['journal_name']?>', '<?php echo $data['article_no']?>', '<?php echo $data['current_stage']?>')"><i class="fa fa-envelope"></i></a></td>
			  <?php if($this->session->userdata('admin_role') == "Super Admin"){?>
              <td>
                <div class="btn-group pull-right">
                <a href="<?= base_url('admin/articles/view/'.$data['id']); ?>" class="btn btn-info"><i class="fa fa-eye"></i></a>
                <a href="<?= base_url('admin/articles/edit/'.$data['id'].'/perevises'); ?>" class="btn btn-warning" id="copyeditor"><i class="fa fa-edit"></i></a>
                <a href="<?= base_url('admin/articles/delete/'.$data['id']); ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-remove"></i></a><br>
                <a href="<?= base_url('admin/articles/pereviseslist/'.$data['article_no']); ?>" class="btn btn-info">View Revises</a>
              </div>
                
              </td>
			  <?php } else if($this->session->userdata('admin_role') == "User") {?>
			  <td>
                <div class="btn-group pull-right">
				<a href="<?= base_url('admin/articles/pereviseslist/'.$data['article_no']); ?>" class="btn btn-info">View Revises</a>
				</div>
              </td>
			  <?php } ?>
  		      </tr>
            <?php $s_no++; endforeach; ?>
			 <?php } else {?>
		  <tr><td colspan="14" class="no_more_rows">No data available in table</td></tr>
		  <?php } ?>
          </tbody>
          </table>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Edit Product-->
    <form action="updateapproved" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Approved Date</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status">
                    <input type="hidden" class="duedate" name="duedate" value="" >
					<input type="hidden" class="article_no" name="article_no" value="">
                    <input type="date" class="form-control approved" name="approved" value="" required>
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
    <!-- Modal Edit Product-->
    <form action="updateSentPdfToPerevises" method="post">
        <div class="modal fade" id="editModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Sent PDF to Author</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status">
                    <input type="hidden" class="duedate" name="duedate" value="" >
                    <input type="hidden" class="article_no1" name="article_no" value="">
                    <input type="date" class="form-control sentpdftope" name="sentpdftope" value="" required>
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
    <!-- Modal Edit Product-->
    <form action="updateRecPdfToPerevises" method="post">
        <div class="modal fade" id="editModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Received PDF from PE</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status">
                    <input type="hidden" class="duedate" name="duedate" value="" >
                    <input type="hidden" class="pdfsenttope" name="pdfsenttope" value="" >
                    <input type="hidden" class="article_no2" name="article_no" value="">
                    <input type="date" class="form-control recpdffrompe" name="recpdffrompe" value="" required>
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
	
	<form action="pe_revises_updatepriority" method="post">
        <div class="modal fade" id="editModal3" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Priority</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Priority</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                     <!-- <input type="text" class="form-control priority" name="priority" value="" >-->
					<select class="form-control" name="priority">
					<option value="">Choose...</option>
					<option value="0">Regular</option>
					<option value="1">High</option>
					</select>
                </div>             
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Priority-->
	
	<form action="notification_email_send" method="post" enctype="multipart/form-data">
        <div class="modal fade" id="editModal5" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><b>Mail</b></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
				<div class="form-group">
                    <label>From</label>
					<input type="hidden" class="form-control current_segment" name="current_segment" value="perevises">
					<?php
					$get_user_name = $this->session->userdata('username');
					$get_user_email_id 	= 	$this->db->select('*')
											->from('ci_users')
											->where('username', $get_user_name)
											->get()
											->result_array();
					if(count($get_user_email_id) > 0)
					{
						$get_email = $get_user_email_id[0]['email'];
					}
					else
					{
						$get_email = '';
					}
					?>
					
					<input type="email" class="form-control from_address" name="from_address" value="<?php echo $get_email;?>" required>
                </div> 	
				<div class="form-group">
                    <label>To</label>
					<input type="email" class="form-control to_address" name="to_address" value="" required>
                </div>

				<div class="form-group">
                    <label>Subject</label>
					<input type="text" class="form-control subject" name="subject" value="" readonly>
                </div> 	

				<div class="form-group">
                    <label>Description</label>
					<textarea type="text" class="form-control description" name="description" value="New Description" required></textarea>
                </div> 		

				<div class="form-group">
                    <label>Upload File</label>
					<input type="file" class="form-control files" name="files">
                </div> 		
				
                <div class="form-group">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
					<input type="hidden" class="id" name="id" value="" >
					
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Send</button>
            </div>
            </div>
        </div>
        </div>
    </form>

<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>

<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": true
    });
  });
</script>
<script>
  $("#invoices").addClass('active');
</script>
<script>
  document.getElementById("copyeditor").onclick = function() {
    //disable
    this.disabled = true;

    //do some validation stuff
}
</script>
<script src="/js/jquery.min.js"></script>
<script src="/js/bootstrap.bundle.min.js"></script>
<script>
// get Edit Product
$('.btn-edit').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const approved = $(this).data('approved');
	const status = $(this).data('status');
	const duedate = $(this).data('duedate');
	////////// Prasanna Added 10-01-2022
	const articleno = $(this).data('articleno');
	
	// Set data to Form Edit
	$('.id').val(id);
	$('.approved').val(approved);
	$('.status').val(status);
	$('.duedate').val(duedate);
	////////// Prasanna Added 10-01-2022
	$('.article_no').val(articleno);
	
	// Call Modal Edit
	$('#editModal').modal('show');
	
});
$('.btn-edit1').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const sentpdftope = $(this).data('sentpdftope');
	const status = $(this).data('status');
	const duedate = $(this).data('duedate');
	////////// Prasanna Added 10-01-2022
	const articleno = $(this).data('articleno');
	
	// Set data to Form Edit
	$('.id').val(id);
	$('.sentpdftope').val(sentpdftope);
	$('.status').val(status);
	$('.duedate').val(duedate);
	////////// Prasanna Added 10-01-2022
	$('.article_no1').val(articleno);
	
	// Call Modal Edit
	$('#editModal1').modal('show');
	
});

$('.btn-edit2').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const pdfsenttope = $(this).data('pdfsenttope');
	const recpdffrompe = $(this).data('recpdffrompe');
	const status = $(this).data('status');
	const duedate = $(this).data('duedate');
	////////// Prasanna Added 10-01-2022
	const articleno = $(this).data('articleno');
	
	// Set data to Form Edit
	$('.id').val(id);
	$('.pdfsenttope').val(pdfsenttope);
	$('.recpdffrompe').val(recpdffrompe);
	$('.status').val(status);
	$('.duedate').val(duedate);
	////////// Prasanna Added 10-01-2022
	$('.article_no2').val(articleno);
	
	// Call Modal Edit
	$('#editModal2').modal('show');
	
});

// get Delete Product
$('.btn-delete').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	// Set data to Form Edit
	$('.productID').val(id);
	// Call Modal Edit
	$('#deleteModal').modal('show');
});

// get Edit Priority
$('.btn-edit3').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const priority = $(this).data('priority');

	// Set data to Form Edit
	$('.id').val(id);
	$('.priority').val(priority);

	// Call Modal Edit
	$('#editModal3').modal('show');
	
});

// get Send Mail
$('.btn-edit5').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const priority = $(this).data('priority');

	// Set data to Form Edit
	$('.id').val(id);
	$('.priority').val(priority);

	// Call Modal Edit
	$('#editModal5').modal('show');
	
});
	
function getting_values(journal_name, article_no, stage)
{
	var mixed = 'CBM tracking system - PE Revises: '+journal_name+'_'+article_no;
	$('.subject').val(mixed);
}	
</script>