<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<style type="text/css">
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
tr td.no_more_rows
{
	text-align:center;
	box-sizing: content-box;    
	border: 1px solid #dee2e6;
	padding: 0.75rem;
	vertical-align: top;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of Articles in Galley Proof </h3>
          </div>
          
        </div>
        <div class="card-body table-responsive">
          <table id="example2" class="table table-bordered table-striped ">
          <thead>
          <tr>                   

            <th>S.NO.</th>
            <th>JOURNAL NAME</th>
  		    <th>ARTICLE NO.</th>
            <th style="display:none;">PROOF PAGES</th>
            <th>RECEIVED FROM AUTHOR</th>
            <th>GALLEY PROOF DUE&nbsp;DATE</th>
            <th>SEND PDF TO AUTHOR</th>
            <th>PDF PAGES</th>
			<th>Suppl. PDF pages</th>
            <th>STATUS</th>
            <th>TYPESETTING REMARKS</th>
			<th>PRIORITY</th>
			<th>EMAIL</th>
			<?php if($this->session->userdata('admin_role') == "Super Admin"){?>
            <th>ACTION</th>
			<?php } ?>
          </tr>
          </thead>
          <tbody>
		   <?php if(count($article_detail) > 0) {?>
            <?php $s_no = 1; foreach($article_detail as $data): ?>

                <?php
//=====================================================================
                   $dateDiff = 0;
                   //$today = date('Y-m-d');
                   $today = $data['sent_to_gp'];
                    $differenceFormat = '%a';
                   $start_date = $data['received_date'];  //echo "***";
                   //$start_date = $data['sent_to_gp'];  echo "<br>";
                   $today; //echo "***";

                    $datetime11 = date_create($start_date);
                    $datetime22 = date_create($today);

                    $intervalQc = date_diff($datetime11, $datetime22);

                    $dateDiff=$intervalQc->format($differenceFormat); 


							$resultDays = array('Monday' => 0,
							'Tuesday' => 0,
							'Wednesday' => 0,
							'Thursday' => 0,
							'Friday' => 0,
							'Saturday' => 0,
							'Sunday' => 0);
							// change string to date time object
							$startDate = new DateTime($start_date);
							$endDate = new DateTime($today);

							// iterate over start to end date
							while($startDate <= $endDate ){
							// find the timestamp value of start date
							$timestamp = strtotime($startDate->format('Y-m-d'));

							// find out the day for timestamp and increase particular day
							$weekDay = date('l', $timestamp);
							$resultDays[$weekDay] = $resultDays[$weekDay] + 1;

							// increase startDate by 1
							$startDate->modify('+1 day');
							}
							
							$sat = $resultDays['Saturday'];
							$sun = $resultDays['Sunday'];
							
							$week_end = $sun+$sat;
						 	$dateDiff = $dateDiff-$week_end; echo "<br>"; //exit; 
//======================================================================
                ?>    
            <?php
				$today = date('Y-m-d');
				if ($data['exp_from_gp'] != '0000-00-00') 
				{
					$due_date = date('d-m-Y',strtotime($data['exp_from_gp']));
				}
			if (!empty($data['due_date']) && $data['due_date'] < $today) {
			?>
            <tr style="color: red !important; font-weight: 700;">
			<?php } else if($data['priority'] == '1'){?>
			<tr style="color: green !important; font-weight: 700;">
			<?php //} else { ?>
               
<?php } else if($dateDiff > 6){ ?>
    <tr style="color: orange !important; font-weight: 700;">
    <?php } else { ?>
			<tr>
			<?php } ?>
              <td class="serial"></td>
              <td><?= $data['journal_name']; ?></td>
              <td><a href="<?= base_url('admin/articles/view/'.$data['id']); ?>"><?= $data['article_no']; ?></a></td>
              <td style="display:none;"><?= $data['proof_pages']; ?></td>
              <td><?= date('d-m-Y',strtotime($data['sent_to_gp'])); ?></td>
              <td><?php
                            if ($data['exp_from_gp'] != '0000-00-00') { 
                     echo date('d-m-Y',strtotime($data['exp_from_gp'])); 
                    }
                     else{
                      echo '---';
                     }
                  ?></td>
			  <td><?php
                  if ($data['sent_pdf_to_author'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-articleno="<?= $data['article_no']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_pdf_to_author']?>"><strong><?= date('d-m-Y',strtotime($data['sent_pdf_to_author']))?></strong></a>
                  <?php }
                  else{ ?>
					<?php if($this->session->userdata('admin_role') == "Super Admin"){?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-articleno="<?= $data['article_no']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_pdf_to_author']?>"><strong>Send</strong></a>
					<?php } else {  echo "-";?>
					
					<?php } ?>
                 <?php }
                ?></td>
                <td><?= $data['pdf_pages']; ?></td>
				<td><?= $data['pdf_pages']; ?></td>
              <td><?= $data['status']; ?></td>
              <td style="text-align:center;"><a href="#" class="btn-remarks" data-id="<?= $data['id']?>" data-remarks_article="<?= $data['remarks_article']?>" data-remarks_ce="<?= $data['remarks_ce']?>" data-remarks_author="<?= $data['remarks_author']?>" data-remarks_typesetting="<?= $data['remarks_typesetting']?>" data-remarks_pe="<?= $data['remarks_pe']?>" data-remarks_production="<?= $data['remarks_production']?>">
					<i class="fa fa-comments" aria-hidden="true" style="font-size:30px;"></i>
					</a></td>
			  <td style="text-align:center;">
				<?php
				if($data['priority'] == 1)
				{?>
					<a href="#" class="btn-edit1" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">
					<img width="25" title="High" src="<?= base_url('assets/dist/img/high_priority.png'); ?>"/>
					</a>
				<?php } else {?>
					<a href="#" class="btn-edit1" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">
					<img width="25" title="Regular" src="<?= base_url('assets/dist/img/regular_priority.png'); ?>"/>
					</a>
				<?php } ?>
				
				</td>
			  <td style="text-align:center;"><a href="#" class="btn-edit5 btn btn-success" data-id="<?= $data['id']?>" onclick="getting_values('<?php echo $data['journal_name']?>', '<?php echo $data['article_no']?>', '<?php echo $data['current_stage']?>')"><i class="fa fa-envelope"></i></a></td>
			  <?php if($this->session->userdata('admin_role') == "Super Admin"){?>
              <td><div class="btn-group pull-right">
                <a href="<?= base_url('admin/articles/view/'.$data['id']); ?>" class="btn btn-info"><i class="fa fa-eye"></i></a>
                <a href="<?= base_url('admin/articles/edit/'.$data['id'].'/galleryproof'); ?>" class="btn btn-warning" id="copyeditor"><i class="fa fa-edit"></i></a>
                <a href="<?= base_url('admin/articles/delete/'.$data['id']); ?>" class="btn btn-danger"  onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-remove"></i></a>
              </div></td>
			  <?php } ?>
  		      </tr>
            <?php $s_no++; endforeach; ?>
			 <?php } else {?>
		  <tr><td colspan="14" class="no_more_rows">No data available in table</td></tr>
		  <?php } ?>
          </tbody>
          </table>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Edit Product-->
    <form action="updateSentPdfToAuthor" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Send PDF to Author</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
				<div class="form-group">
                    <label>PDF Pages </label>
					<input type="text" class="form-control pdf_pages" name="pdf_pages" value="" >
                </div>
				<div class="form-group">
                    <label>Suppl. PDF pages</label>
					<input type="text" class="form-control supp_pdf_pages" name="supp_pdf_pages" value="" >
                </div>
				<div class="form-group">
                    <label>Typesetting Remarks </label>
					<input type="text" class="form-control remarks_typesetting" name="remarks_typesetting" value="" >
                </div>
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status" value="Author" >
                    <input type="hidden" class="articleno" name="articleno" value="" >
                    <input type="date" class="form-control sentpdftoauthor" name="sentpdftoauthor" value="" required >
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
	
	<form action="gallery_proof_updatepriority" method="post">
        <div class="modal fade" id="editModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Priority</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Priority</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                     <!-- <input type="text" class="form-control priority" name="priority" value="" >-->
					<select class="form-control" name="priority">
					<option value="">Choose...</option>
					<option value="0">Regular</option>
					<option value="1">High</option>
					</select>
                </div>             
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
	
	 <form action="notification_email_send" method="post" enctype="multipart/form-data">
        <div class="modal fade" id="editModal5" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><b>Mail</b></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
				<div class="form-group">
                    <label>From</label>
					<input type="hidden" class="form-control current_segment" name="current_segment" value="galleryproof">
					<?php
					$get_user_name = $this->session->userdata('username');
					$get_user_email_id 	= 	$this->db->select('*')
											->from('ci_users')
											->where('username', $get_user_name)
											->get()
											->result_array();
					if(count($get_user_email_id) > 0)
					{
						$get_email = $get_user_email_id[0]['email'];
					}
					else
					{
						$get_email = '';
					}
					?>
					
					<input type="email" class="form-control from_address" name="from_address" value="<?php echo $get_email;?>" required>
                </div> 	
				<div class="form-group">
                    <label>To</label>
					<input type="email" multiple class="form-control to_address" name="to_address" value="" required>
                </div>

				<div class="form-group">
                    <label>Subject</label>
					<input type="text" class="form-control subject" name="subject" value="" readonly>
                </div> 	

				<div class="form-group">
                    <label>Description</label>
					<textarea type="text" class="form-control description" name="description" value="New Description" required></textarea>
                </div> 		

				<div class="form-group">
                    <label>Upload File</label>
					<input type="file" class="form-control files" name="files">
                </div> 		
				
                <div class="form-group">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
					<input type="hidden" class="id" name="id" value="" >
					
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Send</button>
            </div>
            </div>
        </div>
        </div>
    </form>

<!-- Remarks Start -->
	
	<div class="modal fade" id="all_remarks" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Remarks</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                    <input type="hidden" class="id" name="id" value="" >
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Fresh Article</label>
                    <input style="width:100%;" type="text" class="remarks_article" value="">
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Copyediting</label>
                    <input style="width:100%;" type="text" class="remarks_ce" value="">
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">CE Proof - Author</label>
                    <input style="width:100%;" type="text" class="remarks_author" value="">
                </div>  
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Typesetting</label>
                    <input style="width:100%;" type="text" class="remarks_typesetting" value="">
                </div>
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Production Editor</label>
                    <input style="width:100%;" type="text" class="remarks_pe" value="">
                </div>	
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Production</label>
                    <input style="width:100%;" type="text" class="remarks_production" value="">
                </div>				
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary" style="display:none;">Update</button>
            </div>
            </div>
        </div>
        </div>
<!-- Remarks End -->


<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>

<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": true
    });
  });
</script>
<script>
  $("#invoices").addClass('active');
</script>
<script>
  document.getElementById("copyeditor").onclick = function() {
    //disable
    this.disabled = true;

    //do some validation stuff
}
</script>
<script src="/js/jquery.min.js"></script>
<script src="/js/bootstrap.bundle.min.js"></script>
<script>


// get Edit Product
$('.btn-edit').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const sentpdftoauthor = $(this).data('sentpdftoauthor');
	const status = $(this).data('status');
	const articleno = $(this).data('articleno');
	// Set data to Form Edit
	$('.id').val(id);
	$('.sentpdftoauthor').val(sentpdftoauthor);
	$('.status').val(status);
	$('.articleno').val(articleno);
	
	// Call Modal Edit
	$('#editModal').modal('show');
	
});

// get Delete Product
$('.btn-delete').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	// Set data to Form Edit
	$('.productID').val(id);
	// Call Modal Edit
	$('#deleteModal').modal('show');
});

// get Edit Priority
$('.btn-edit1').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const priority = $(this).data('priority');

	// Set data to Form Edit
	$('.id').val(id);
	$('.priority').val(priority);

	// Call Modal Edit
	$('#editModal1').modal('show');
	
});

// get Send Mail
$('.btn-edit5').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const priority = $(this).data('priority');

	// Set data to Form Edit
	$('.id').val(id);
	$('.priority').val(priority);

	// Call Modal Edit
	$('#editModal5').modal('show');
	
});

// get remarks model
$('.btn-remarks').on('click',function(){
	
	// get data from button edit
	const id = $(this).data('id');
	const remarks_article = $(this).data('remarks_article');
	const remarks_ce = $(this).data('remarks_ce');
	const remarks_author = $(this).data('remarks_author');
	const remarks_typesetting = $(this).data('remarks_typesetting');
	const remarks_pe = $(this).data('remarks_pe');
	const remarks_production = $(this).data('remarks_production');
	
	
	// Set data to Form Edit
	$('.id').val(id);
	$('.remarks_article').val(remarks_article);
	$('.remarks_ce').val(remarks_ce);
	$('.remarks_author').val(remarks_author);
	$('.remarks_typesetting').val(remarks_typesetting);
	$('.remarks_pe').val(remarks_pe);
	$('.remarks_production').val(remarks_production);
	
	
	// Call Modal Edit
	$('#all_remarks').modal('show');
	
});	
	
function getting_values(journal_name, article_no, stage)
{
	var mixed = 'CBM tracking system - Galley Proof: '+journal_name+'_'+article_no;
	$('.subject').val(mixed);
}		
	
</script>