<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css">
<style type="text/css">
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
tr td.no_more_rows
{
	text-align:center;
	box-sizing: content-box;    
	border: 1px solid #dee2e6;
	padding: 0.75rem;
	vertical-align: top;
}
</style> 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of Articles in CE to Author </h3>
          </div>
          
        </div>
        <div class="card-body table-responsive">
          <table id="example2" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>JOURNAL NAME</th>
  		      <th>ARTICLE NO.</th>
            <th>WORD COUNT</th>
            <th>SENT TO AUTHOR</th>
            <th>EXPECTED FROM AUTHOR</th>
            <th>RECEIVED FROM AUTHOR</th>
			
            <th>STATUS</th>
            <th>AUTHOR REMARKS</th>
			<th>PRIORITY</th>
			<th>EMAIL</th>
			<?php if($this->session->userdata('admin_role') == "Super Admin"){?>
            <th>ACTION</th>
			<?php } ?>
          </tr>
          </thead>
          <tbody>
		   <?php if(count($article_detail) > 0) {?>
            <?php $s_no = 1; foreach($article_detail as $data): ?>
            <?php
				$today = date('Y-m-d');
			if ($data['exp_from_author'] != '0000-00-00' && $data['exp_from_author'] < $today) {
			?>
            <tr style="color: red !important; font-weight: 700;">
			<?php } else if($data['priority'] == '1'){?>
			<tr style="color: green !important; font-weight: 700;">
			<?php } else { ?>
			<tr>
			<?php } ?>
              <td class="serial"></td>
              <td><?= $data['journal_name']; ?></td>
              <td><a href="<?= base_url('admin/articles/view/'.$data['id']); ?>"><?= $data['article_no']; ?></a></td>
              <td><?= $data['ce_proof_pages']; ?></td>
              <td><?= date('d-m-Y',strtotime($data['sent_to_author'])); ?></td>
              <td><?php
                            if ($data['exp_from_author'] != '0000-00-00') { 
                     echo date('d-m-Y',strtotime($data['exp_from_author'])); 
                    }
                     else{
                      echo '---';
                     }
                  ?></td>
              <td><?php
                  if ($data['sent_to_gp'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_to_gp']?>"><strong><?= date('d-m-Y',strtotime($data['sent_to_gp']))?></strong></a>
                  <?php }
                  else{ ?>
						<?php if($this->session->userdata('admin_role') == "Super Admin"){?>
						<a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_to_gp']?>"><strong>Receive</strong></a>
						<?php } else { echo "-"; ?>
						
						<?php } ?>
                 <?php }
                ?></td>
				
              <td><?= $data['status']; ?></td>
               <td style="text-align:center;"><a href="#" class="btn-remarks" data-id="<?= $data['id']?>" data-remarks_article="<?= $data['remarks_article']?>" data-remarks_ce="<?= $data['remarks_ce']?>" data-remarks_author="<?= $data['remarks_author']?>" data-remarks_typesetting="<?= $data['remarks_typesetting']?>" data-remarks_pe="<?= $data['remarks_pe']?>" data-remarks_production="<?= $data['remarks_production']?>">
					<i class="fa fa-comments" aria-hidden="true" style="font-size:30px;"></i>
					</a></td>
			  <td style="text-align:center;">
				<?php
				if($data['priority'] == 1)
				{?>
					<a href="#" class="btn-edit1" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">
					<img width="25" title="High" src="<?= base_url('assets/dist/img/high_priority.png'); ?>"/>
					</a>
				<?php } else {?>
					<a href="#" class="btn-edit1" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">
					<img width="25" title="Regular" src="<?= base_url('assets/dist/img/regular_priority.png'); ?>"/>
					</a>
				<?php } ?>
				
				</td>
			  <td style="text-align:center;"><a href="#" class="btn-edit5 btn btn-success" data-id="<?= $data['id']?>" onclick="getting_values('<?php echo $data['journal_name']?>', '<?php echo $data['article_no']?>', '<?php echo $data['current_stage']?>')"><i class="fa fa-envelope"></i></a></td>
			  <?php if($this->session->userdata('admin_role') == "Super Admin"){?>
              <td><div class="btn-group pull-right">
                <a href="<?= base_url('admin/articles/view/'.$data['id']); ?>" class="btn btn-info"><i class="fa fa-eye"></i></a>
                <a href="<?= base_url('admin/articles/edit/'.$data['id'].'/ceproof'); ?>" class="btn btn-warning" id="copyeditor"><i class="fa fa-edit"></i></a>
                <a href="<?= base_url('admin/articles/delete/'.$data['id']); ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-remove"></i></a>
              </div></td>
			  <?php } ?>
  		      </tr>
            <?php $s_no++; endforeach; ?>
			 <?php } else {?>
		  <tr><td colspan="12" class="no_more_rows">No data available in table</td></tr>
		  <?php } ?>
          </tbody>
          </table>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Edit Product-->
    <form action="updateReceivedfromAuthor" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Received from Author</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
				<div class="form-group">
                    <label>Author Remarks </label>
					<input type="text" class="form-control remarks_author" name="remarks_author" value="" >
                </div>
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status" value="Gallery Proof" >
                    <input type="hidden" class="duedate" name="duedate" value="" >
                    <input type="date" class="form-control receivedfromauthor" name="receivedfromauthor" value="" required>
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
	
	<form action="ceproof_updatepriority" method="post">
        <div class="modal fade" id="editModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Priority</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Priority</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                     <!-- <input type="text" class="form-control priority" name="priority" value="" >-->
					<select class="form-control" name="priority">
					<option value="">Choose...</option>
					<option value="0">Regular</option>
					<option value="1">High</option>
					</select>
                </div>             
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Priority-->
	
	<form action="notification_email_send" method="post" enctype="multipart/form-data">
        <div class="modal fade" id="editModal5" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><b>Mail</b></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
				<div class="form-group">
                    <label>From</label>
					<input type="hidden" class="form-control current_segment" name="current_segment" value="ceproof">
					<?php
					$get_user_name = $this->session->userdata('username');
					$get_user_email_id 	= 	$this->db->select('*')
											->from('ci_users')
											->where('username', $get_user_name)
											->get()
											->result_array();
					if(count($get_user_email_id) > 0)
					{
						$get_email = $get_user_email_id[0]['email'];
					}
					else
					{
						$get_email = '';
					}
					?>
					
					<input type="email" class="form-control from_address" name="from_address" value="<?php echo $get_email;?>" required>
                </div> 	
				<div class="form-group">
                    <label>To</label>
					<input type="email" multiple class="form-control to_address" name="to_address" value="" required>
                </div>

				<div class="form-group">
                    <label>Subject</label>
					<input type="text" class="form-control subject" name="subject" value="" readonly>
                </div> 	

				<div class="form-group">
                    <label>Description</label>
					<textarea type="text" class="form-control description" name="description" value="New Description" required></textarea>
                </div> 		

				<div class="form-group">
                    <label>Upload File</label>
					<input type="file" class="form-control files" name="files">
                </div> 		
				
                <div class="form-group">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
					<input type="hidden" class="id" name="id" value="" >
					
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Send</button>
            </div>
            </div>
        </div>
        </div>
    </form>
	
	<!-- Remarks Start -->
	
	<div class="modal fade" id="all_remarks" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Remarks</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                    <input type="hidden" class="id" name="id" value="" >
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Fresh Article</label>
                    <input style="width:100%;" type="text" class="remarks_article" value="">
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Copyediting</label>
                    <input style="width:100%;" type="text" class="remarks_ce" value="">
                </div> 
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">CE Proof - Author</label>
                    <input style="width:100%;" type="text" class="remarks_author" value="">
                </div>  
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Typesetting</label>
                    <input style="width:100%;" type="text" class="remarks_typesetting" value="">
                </div>
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Production Editor</label>
                    <input style="width:100%;" type="text" class="remarks_pe" value="">
                </div>	
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Production</label>
                    <input style="width:100%;" type="text" class="remarks_production" value="">
                </div>				
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary" style="display:none;">Update</button>
            </div>
            </div>
        </div>
        </div>
	
	<!-- Remarks End -->

<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>

<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": true
    });
  });
</script>
<script>
  $("#invoices").addClass('active');
</script>
<script>
  document.getElementById("copyeditor").onclick = function() {
    //disable
    this.disabled = true;

    //do some validation stuff
}
</script>
<script src="/js/jquery.min.js"></script>
<script src="/js/bootstrap.bundle.min.js"></script>
<script>


// get Edit Product
$('.btn-edit').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const receivedfromauthor = $(this).data('receivedfromauthor');
	const status = $(this).data('status');
	const duedate = $(this).data('duedate');
	// Set data to Form Edit
	$('.id').val(id);
	$('.receivedfromauthor').val(receivedfromauthor);
	$('.status').val(status);
	$('.duedate').val(duedate);
	
	// Call Modal Edit
	$('#editModal').modal('show');
	
});

// get Delete Product
$('.btn-delete').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	// Set data to Form Edit
	$('.productID').val(id);
	// Call Modal Edit
	$('#deleteModal').modal('show');
});

// get Edit Priority
$('.btn-edit1').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const priority = $(this).data('priority');

	// Set data to Form Edit
	$('.id').val(id);
	$('.priority').val(priority);

	// Call Modal Edit
	$('#editModal1').modal('show');
	
});
	
// get Send Mail
$('.btn-edit5').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const priority = $(this).data('priority');

	// Set data to Form Edit
	$('.id').val(id);
	$('.priority').val(priority);

	// Call Modal Edit
	$('#editModal5').modal('show');
	
});

// get remarks model
$('.btn-remarks').on('click',function(){
	
	// get data from button edit
	const id = $(this).data('id');
	const remarks_article = $(this).data('remarks_article');
	const remarks_ce = $(this).data('remarks_ce');
	const remarks_author = $(this).data('remarks_author');
	const remarks_typesetting = $(this).data('remarks_typesetting');
	const remarks_pe = $(this).data('remarks_pe');
	const remarks_production = $(this).data('remarks_production');
	
	
	// Set data to Form Edit
	$('.id').val(id);
	$('.remarks_article').val(remarks_article);
	$('.remarks_ce').val(remarks_ce);
	$('.remarks_author').val(remarks_author);
	$('.remarks_typesetting').val(remarks_typesetting);
	$('.remarks_pe').val(remarks_pe);
	$('.remarks_production').val(remarks_production);
	
	
	// Call Modal Edit
	$('#all_remarks').modal('show');
	
});		
	
function getting_values(journal_name, article_no, stage)
{
	var mixed = 'CBM tracking system - CE proof for author approval: '+journal_name+'_'+article_no;
	$('.subject').val(mixed);
}		
</script>