<?php
	class Issues_model extends CI_Model{

		//---------------------------------------------------
		// Get Issue detial by ID
		public function issue_detail($id){
			$query = $this->db->get_where('fms_create_issues', array('id' => $id));
			return $result = $query->row_array();
		}

		//---------------------------------------------------
		// Insert New Issue
		public function add_issue($data){
			return $this->db->insert('fms_create_issues', $data);
		}
		public function update_issue($data){
			$this->db->where('article_no', $data['article_no']);
			return $this->db->update('fms_create_issues', $data);
		}
		public function update_revised_issue($data,$id){
			$this->db->where('id', $id);
			return $this->db->update('issue_revises', $data);
		}
		public function publish_revised_issue($data,$issue_name){
			//print_r($data); 
			$this->db->where('issue_name', $issue_name);
			return $this->db->update('issue_revises', $data);
		}
		public function publish_fms_create_table($data,$issue_name){
			//print_r($data); exit;
			$this->db->where('issue_name', $issue_name);
			return $this->db->update('fms_create_issues', $data);
		}
		public function get_all_published(){
			$this->db->select('*');
			$this->db->from('journal');
			$this->db->where('current_stage','Published');
			$query = $this->db->get();
			return $query->result_array();
		}
		// //---------------------------------------------------
		// // Get Add Issue
		public function get_all_issues(){
			$this->db->select('
					fms_create_issues.id,
					fms_create_issues.issue_name,
	    			fms_create_issues.issue_id,
	    			fms_create_issues.journal_name,
					fms_create_issues.article_no,
					fms_create_issues.no_of_pages,
					fms_create_issues.start_page,
					fms_create_issues.end_page,
					fms_create_issues.order_by,
					fms_create_issues.created_by,
					fms_create_issues.is_delete,
					fms_create_issues.created_date,
					'
	    	);
	    	$this->db->from('fms_create_issues');
	    	$query = $this->db->get();					 
			return $query->result_array();
		}

		//---------------------------------------------------
		// Get Issue Detail by ID
		public function get_issue_by_id($id){

			$this->db->select('
					fms_create_issues.id,
					fms_create_issues.issue_name,
	    			fms_create_issues.article_no,
	    			fms_create_issues.issue_year,
					fms_create_issues.issue_month,
					fms_create_issues.pdf_pages,
					fms_create_issues.order_by,
					fms_create_issues.doi_number,
					fms_create_issues.created_date,
					'
	    	);
	    	$this->db->from('fms_create_issues');
	    	$this->db->where('fms_create_issues.id' , $id);
	    	$query = $this->db->get();					 
			return $query->row_array();

		}



		//---------------------------------------------------
		// Get Issue Detail by ID
		// public function update_issue($data, $id){
		// 	$this->db->where('issue_name', $id);
		// 	return $this->db->update('fms_create_issues', $data);
		// }

		public function update_revises_data($data){
			return $this->db->insert('issue_revises', $data);
		}
		
		/* public function update_revises_data($data){
			
			$this->db->select('*');
	    	$this->db->from('issue_revises');
	    	//$this->db->group_by('issue_name');
	    	$this->db->where('issue_name', $data['issue_name']);
	    	$query = $this->db->get();					 
			// venkat query updated
			$nums = $query->num_rows();
			if($nums == '0')
			{
				return $this->db->insert('issue_revises', $data);
			}
			else
			{
				$this->db->where('issue_name', $data['issue_name']);
				return $this->db->update('issue_revises',$data);
			}
			//print_r($data);exit;
			
		} */

		public function updatearticle_status($data, $article_no){
			$this->db->where('article_no', $article_no);
			return $this->db->update('journal',$data);
		}
		public function updatearticle_status1($article_no){
			$this->db->set('current_stage', "Published");
			$this->db->where('article_no', $article_no);
			return $this->db->update('journal',$data);
		}


		public function get_all_issue_processing(){
			$this->db->select('*');
	    	$this->db->from('fms_create_issues');
	    	$this->db->group_by('issue_name');
	    	$this->db->where('status', "New");
	    	$query = $this->db->get();					 
			return $query->result_array();
		}
		
		public function get_all_issue_production(){
			$this->db->select('*');
	    	$this->db->from('fms_create_issues');
			$this->db->group_by('issue_name');
	    	$this->db->where('status', "Production");
			/* $this->db->from('fms_create_issues');
			$this->db->join('issue_revises', 'issue_revises.issue_name = fms_create_issues.issue_name');
	    	$this->db->group_by('fms_create_issues.issue_name');
	    	$this->db->where('fms_create_issues.status', "Production"); */
	    	$query = $this->db->get();					 
			return $query->result_array();
		}
		public function get_all_revised_issue(){
		/*	$this->db->select('*');
	    	$this->db->from('fms_create_issues'); 	
			$this->db->join('issue_revises', 'issue_revises.issue_name = fms_create_issues.issue_name');
			//$this->db->join('SELECT MAX(id) as max_id  FROM issue_revises where issue_name = ');
			//$this->db->selectMax('issue_revises.id');
			$this->db->where_in('issue_revises.status', ["Production","Author"]); 
			//$this->db->where('issue_revises.rec_from_prod!=', "0000-00-00");
			//$this->db->where('issue_revises.published_date', "0000-00-00");
			//$this->db->group_by('issue_revises.issue_name, issue_revises.id');
			$this->db->group_by('issue_revises.issue_name');
			//$this->db->order_by('issue_revises.id', "desc");
			//$this->db->having('MAX(issue_revises.id)');
			//$this->db->order_by('fms_create_issues.id', "desc");
			$this->db->limit(10);
	    	$query = $this->db->get();					 
			return $query->result_array();  */
 
			//--------------------------------------------------
			// Sub Query
			$this->db->select('MAX(id) as max_id')->from('issue_revises');
			$this->db->where_in('status', ["Production","Author"]);
			$this->db->group_by('issue_name');
			//$subQuery = $this->db->get();	
			$subQuery =  $this->db->get_compiled_select();

			// Main Query
			$this->db->select('*')
			->from('fms_create_issues as fm,issue_revises as rev')
			->where('rev.issue_name=fm.issue_name');
			$this->db->where("rev.id IN ($subQuery)", NULL, FALSE);
			$this->db->group_by('fm.issue_name'); 
			$this->db->order_by('fm.id', "desc");

			$query = $this->db->get();	
			// print_r($this->db->last_query());				 
			return $query->result_array(); 
			
			//--------------------------------------------------

			
		}
		public function get_all_issue_published(){
			$this->db->select('*');
	    	$this->db->from('fms_create_issues');
			//$this->db->from('issue_revises');
	    	$this->db->group_by('issue_name');
	    	$this->db->where('status', "Published");
			//$this->db->order_by('issue_name', "desc");
			$order_by = "lpad(issue_name, 10, 0) Desc";
			$this->db->order_by('published_date','desc');
	    	//$this->db->order_by($order_by);		
			//echo $this->db->get_compiled_select();exit;
	    	$query = $this->db->get();					 
			return $query->result_array();
		}
		public function get_issue_by_name($issue_name){

			$this->db->select('*');
	    	$this->db->from('journal');
	    	$this->db->join('fms_create_issues', 'journal.article_no = fms_create_issues.article_no');
	    	$this->db->where('issue_name' , $issue_name);
			//$this->db->order_by('first_page', 'ASC');
			$order_by = "lpad(order_by, 10, 0) ASC";
	    	$this->db->order_by($order_by);			
			//echo $this->db->get_compiled_select();
	    	$query = $this->db->get();					 
			return $query->result_array();

		}
		public function get_revised_issue_by_name($issue_name){

			$this->db->select('*');
	    	$this->db->from('issue_revises');
	    	//$this->db->join('fms_create_issues', 'journal.article_no = fms_create_issues.article_no');
	    	$this->db->where('issue_name' , $issue_name);
	    	$this->db->order_by('id', "ASC");
	    	$query = $this->db->get();					 
			return $query->result_array();

		}
		public function get_all_issuereviseslist($issue_name){
			$this->db->select('*');
			$this->db->from('issue_revises');
			$this->db->where('issue_name', $issue_name);
			$query = $this->db->get();
			return $query->result_array();
		}
		public function update_order($data, $article_no)
	    {
	        $this->db->where('article_no', $article_no);
			$this->db->update('journal', $data);
			return true;
	    }


	    public function getissues(){

	    // Fetch users
	    $this->db->select('*');
	    $this->db->join('journal', 'journal.article_no = fms_create_issues.article_no');
	    $fetched_records = $this->db->get('fms_create_issues');
	    $query = $fetched_records->result_array();

	    return $query;
	  }

	  // Update record
	  public function updateissue($article_no,$field,$value){

	    // Update
	    $data=array($field => $value);
	    $this->db->where('article_no',$article_no);
	    $this->db->update('fms_create_issues',$data);
	  }




	  public function load_data($issue_name)
		{
		$this->db->select('*');
	    	$this->db->from('fms_create_issues');
	    	$this->db->where('issue_name' , $issue_name);
	    	$this->db->order_by('order_by', 'ASC');
	    	$query = $this->db->get();					 
			return $query->result_array();
		}
	  public function update($data, $id)
		 {
		  $this->db->where('id', $id);
		  $this->db->update('fms_create_issues', $data);
		 }		 				public function get_doi_number_model($article_no)		{			$this->db->select('*');	    	$this->db->from('journal');	    	$this->db->where('article_no' , $article_no);	    	$query = $this->db->get();					 			return $query->result_array();		}
		 
		 public function update_fms_create_issues($data, $id)
		 {
			 /* print_r($data);
			 echo $id; exit; */
			 
			 
		  $this->db->where('issue_name', $data['issue_name']);
		  $this->db->update('fms_create_issues', $data);
		 }
	}

?>