// services/QueryService.js
import prisma from '@/lib/prismaconfig';

// Get all Knowledges

export const getAllQueries = async () => {
  return await prisma.acs_queries.findMany({
    include: {
      user: {
        select: {
          user_name: true,
        },
      },
      user_repliedBy: {
        select: {
          user_name: true,
        },
      },
      chapter: {
        select: {
          chap_title: true,
        },
      },
      book: {
        select: {
          book_title: true,
        },  
      },
      task: {
        select: {
          task_name: true,
        },
      },
    },

    where: {
      queries_isdelete: "active",
    },
  });
};

// Create new Knowledges
export const createQuery = async (data) => {
  return await prisma.acs_queries.create({
    data,
  });
};

export const getQueryById  = async (queriesPid ) => {
  return await prisma.acs_queries.findUnique({
    where: { queries_pid : Number(queriesPid ) },
  });
};



export const updateQuery = async (queryPid, data) => {
  return await prisma.acs_queries.update({
    where: { queries_pid: Number(queryPid) },
    data,
  });
};

