import prisma from "@/lib/prismaconfig"; // Adjust path to your Prisma client instance

export const getAllBreaks = async () => {
    return await prisma.acs_breaks.findMany();
};

export const createBreakResponse = async (data) => {
   const entry = await prisma.acs_break_hours_details.create({
    data,
  });
    return entry;
};

export const updateBreakResponse = async (bh_pid, data) => {
  return await prisma.acs_break_hours_details.update({
    where: { bh_pid: Number(bh_pid) },
    data,
  });
};

export const getBreakById = async (bh_pid) => {
  return await prisma.acs_break_hours_details.findUnique({
    where: { bh_pid: Number(bh_pid) },
  });
};

export const CheckBreaks = async (user_pid) => {
  const breakCount = await prisma.acs_break_hours_details.findFirst({
    where: {
      bh_createdBy : user_pid, // Ensure it's a number if bh_empId is an integer column
      bh_endDate: null,
    },
  });
  console.log(breakCount)
  return breakCount; 
};

export const CheckEntrys = async (user_pid) => {
  const entryCount = await prisma.acs_entry.count({
    where: {
      entry_createdBy : Number(user_pid), // Ensure it's a number if bh_empId is an integer column
      entry_end_date  : null,
      entry_end_time  : null,
      entry_isdelete  : "active"
    },
  });
  console.log(entryCount);
  return entryCount; 
};

export const PendingCheckEntrys = async (user_pid) => {
  const entryCount = await prisma.acs_pending_resume.count({
    where: {
      pr_resumeTime : Number(user_pid), // Ensure it's a number if bh_empId is an integer column
      pr_resumeTime  : null,
      pr_resumeTime  : null,
      pr_isdelete  : "active"
    },
  });
  console.log(entryCount);
  return entryCount; 
};


