// app/users/create/actions.js
'use server';

import { createKnowledge, updateKnowledge } from '@/lib/services/knowledgeService';
import fs from "fs";
import path from "path";

export async function createKnowledgeAction(formData) {
  try {
    const knowledge_name = formData.get("knowledge_name");
    const knowledge_createdBy = parseInt(formData.get("knowledge_createdBy"));

    let knowledgeFilePath = null;
    const file = formData.get("knowledge_file");

    if (file && file.name) {
      const arrayBuffer = await file.arrayBuffer();
      const buffer = Buffer.from(arrayBuffer);

      // get extension from uploaded file
      const ext = path.extname(file.name);
      const newFilename = file.name;
      const newPath = path.join(process.cwd(), "public", "Knowledge", newFilename);

      // save file
      fs.writeFileSync(newPath, buffer);

      // only save filename in DB
      knowledgeFilePath = newFilename;
    }
    const userData = {
      knowledge_name,
      knowledge_createdBy,
      knowledge_file: knowledgeFilePath,
    };
    await createKnowledge(userData);
    return {
      success: true,
      message: "Knowledge ceated Successfully",
      userData: userData,
    };
  } catch (error) {
    console.error("Error creating knowledge details:", error);
    return {
      success: false,
      message: "Server error during knowledge details"
    };
  }
}

export async function updateKnowledgeAction(knowledgeId, formData) {
  try {
    const knowledge_name = formData.get("knowledge_name");

    const userData = {
      knowledge_name
    };
    let knowledgeFilePath = null;
    const file = formData.get("knowledge_file");

    if (file && file.name) {
      const arrayBuffer = await file.arrayBuffer();
      const buffer = Buffer.from(arrayBuffer);

      // get extension from uploaded file
      const ext = path.extname(file.name);
      const newFilename = file.name;
      const newPath = path.join(process.cwd(), "public", "Knowledge", newFilename);

      // save file
      fs.writeFileSync(newPath, buffer);

      // only save filename in DB
      knowledgeFilePath = newFilename;
      userData.knowledge_file = knowledgeFilePath;
    }
    await updateKnowledge(knowledgeId, userData);
    return {
      success: true,
      message: "Knowledge updated Successfully",
      userData: userData,
    };
  } catch (error) {
    console.error("Error creating knowledge details:", error);
    return {
      success: false,
      message: "Server error during knowledge details"
    };
  }
}



export async function updateDeleteAction(knowledgeId, payload) {
  try {
    const knowledge = await updateKnowledge(knowledgeId, payload);
    return {
      success: true,
      message: "Knowledge deleted Successfully",
      knowledge
    };
  } catch (error) {
    console.error("Error updateing knowledge details:", error);
    return {
      success: false,
      message: "Server error during knowledge details"
    };
  }
}