// app/holidays/create/actions.js
'use server';

import { createHoliday, updateHoliday,getHolidayByDate } from '@/lib/services/holidayService';



export async function createHolidayAction(payload) {
  try {
    const holiday_date    = payload.holiday_date;
    const existingHoliday = await getHolidayByDate(holiday_date);
     if (existingHoliday) {
      return {
        success: false,
        message: "Holiday date already exists",
      };
    }
    const holiday = await createHoliday(payload);
    return {
      success: true,
      message: "Holiday Created Successfully",
      holiday
    };
  } catch (error) {
    console.error("Error creating holiday details:", error);
    return {
      success: false,
      message: "Server error during holiday details"
    };
  }
}

export async function updateHolidayAction(holidayId, payload) {
  try {
    const holidays = await updateHoliday(holidayId, payload);
    return {
      success: true,
      message: "Holiday updated Successfully",
      holidays
    };
  } catch (error) {
    console.error("Error updateing holiday details:", error);
    return {
      success: false,
      message: "Server error during holiday details"
    };
  }
}