// app/books/create/actions.js
'use server';

import { createCEAssign,selectUserDetails, CEDetailsUpdate, getCEDetailsById } from '@/lib/services/copyeditingService';
import fs from "fs";
import path from "path";
import { sendEmail, sendEmailTest } from '@/lib/services/emailService';
import { encryptNumber } from '@/lib/encryption';
import { selectChapterList } from '../services/chapterService';
export async function CEUpdate(payload) {
  try {

    const chapter_id    = payload.ce_chap_id;
    const ce_sent_note  = payload.ce_sent_note;
    const ce_sent_comments = payload.ce_sent_comments;
    const ce_due_date_raw = payload.ce_due_date;
    const ce_due_date = new Date(ce_due_date_raw).toLocaleDateString('en-GB');
    const editorId      = payload.ce_editor_id; 

    const chapter_data  = await selectChapterList(chapter_id);
    
    const chapter_title = chapter_data[0]?.chap_title;
    const book_title    = chapter_data[0]?.book?.book_title;

    const email_data  = await selectUserDetails(editorId);
    const user_name    = email_data[0]?.user_name;
    
    const createdEntry = await createCEAssign(payload);
    const lastInsertId = createdEntry.ce_pid;

    const encrypt_id  = encryptNumber(lastInsertId);
     
    if (!email_data) {
          return { success: false, message: "Email ID not found" };
        }

        const to = email_data[0]?.user_email;
        const subject = `Article for copyedit: ${book_title} - ${chapter_title}`;

        const Url = `${process.env.NEXTAUTH_URL}/copyediting/accept?editor=${encrypt_id}`;
        
        //const formattedDate = moment().format("DD MMMM YYYY");
      /* const text = `
        <div style="font-family: Calibri, Arial, sans-serif; font-size:15px; color:#000000; line-height:1.5; max-width:600px; margin:0 auto; padding:10px;">

          <!-- Greeting -->
          <div style="margin-bottom:10px;">Hi ${user_name},</div>

          <!-- Intro -->
          <div style="margin-bottom:10px;">Please find a file for copyediting at the following link.</div>
          <div style="margin-bottom:10px;">There are 0000 words in the file.</div>
          <div style="margin-bottom:10px;">We would like the paper returned by <strong>${ce_due_date}</strong>.</div>

          <!-- Comments & Notes -->
          <div style="margin-bottom:10px;">Please note the following comment(s) on this article:${ce_sent_comments}</div>
          <div style="margin-bottom:10px;">Please note the following production note(s) on this article:${ce_sent_note}</div>
          <!-- Action -->
          <div style="margin-bottom:10px;">
            If you are available to take on this assignment, please <b><a href=${Url}>ACCEPT</a></b>. If you are not available, please <b>REJECT</b> using the link below.
          </div>
          <!-- Closing -->
          <div style="margin-bottom:10px;">Many thanks for your continued support.</div>
          <div style="margin-bottom:5px;">Best Regards,</div>
          <div style="margin:0;"><b>Ebooks Copyedit Team</b></div>
        </div>
    `;
     
        const cc = [];
        const bcc =  process.env.CE_BCCEMAILS ? process.env.CE_BCCEMAILS.split(",").map(email => email.trim()) : [];

        const mailResult = await sendEmail(to, subject, text, cc, bcc); */

        const text = `
        <div style="font-family: Calibri, Arial, sans-serif; font-size:15px; color:#000000; 
        line-height:1.2;max-width:600px;margin-bottom:10px;">

          <!-- Greeting -->
          <p>Hi ${user_name},</p>

          <!-- Intro -->
          <p>Please find a file for copyediting at the following link.<br><br>
             There are 0000 words in the file.<br><br>
             We would like the paper returned by <strong>${ce_due_date}</strong>.<br><br>

          <!-- Comments & Notes -->
             Please note the following comment(s) on this article:${ce_sent_comments}<br><br>
             Please note the following production note(s) on this article:${ce_sent_note}<br><br>
          <!-- Action -->
            If you are available to take on this assignment, please <b><a href=${Url}>ACCEPT</a></b>. If you are not available, please <b>REJECT</b> using the link below.<br><br>
          <!-- Closing -->
           Many thanks for your continued support.</p>
          <p>Best Regards,<br>
             <b>Ebooks Copyedit Team</b></p>
        </div> 
    `;
     
        const cc = [];
        const bcc =  process.env.CE_BCCEMAILS ? process.env.CE_BCCEMAILS.split(",").map(email => email.trim()) : [];

        const mailResult = await sendEmailTest(to, subject, text, cc, bcc);
        
    let QCUploadFilePath = "";
    const filename = payload.ce_sent_file; // '1761720598155_Mail Templates - Appraisal.docx'

    if (filename) {
      // 1️⃣ Source folder (where the file currently exists)
      const sourceFolder = path.join(process.cwd(), "public", "First_check");
      const sourcePath = path.join(sourceFolder, filename);

      // Check if source file exists
      if (!fs.existsSync(sourcePath)) {
        throw new Error(`Source file does not exist: ${sourcePath}`);
      }

      // 2️⃣ Target folder (where you want to copy the file)
      const targetFolder = path.join(process.cwd(), "public", "CE/Send_Files");
      if (!fs.existsSync(targetFolder)) fs.mkdirSync(targetFolder, { recursive: true });
      const targetPath = path.join(targetFolder, filename);

      // 3️⃣ Copy the file
      fs.copyFileSync(sourcePath, targetPath);

      // Save filename for DB
      QCUploadFilePath = filename;

      //console.log("File copied successfully:", targetPath);
    }

    return {
      success: true,
      message: "Entry CE Assign File successfully",
      createdEntry
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}


// export async function acceptCEAction(EdDetailsId, payload) {
//   try {
//     console.log("acceptCEAction called with::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::", EdDetailsId, payload);
//     // return
    
//     const EditingDetails = await CEDetailsUpdate(EdDetailsId, payload);

//     return {
//       success: true,
//       message: "Accepted Successfully",
//       EditingDetails
//     };
//   } catch (error) {
//     console.error("Error updateing details:", error);
//     return {
//       success: false,
//       message: "Server error during details"
//     };
//   }
// }



export async function uploadCEAction(EdDetailsId, formData) {
  let previousState = null;
  let EditingDetails = null;
  try {
    console.log("Upload CEAction called with EdDetailsId:", EdDetailsId);
    previousState = await getCEDetailsById(EdDetailsId);
    
    if (!previousState) {
      throw new Error("Record not found");
    }

    // --- 1. Retrieve data from the FormData object ---
    // Get the File object (name used in formData.append on client)
    const file = formData.get('ce_received_file'); // <--- FIX: Access File from FormData

    // Get other fields as strings
    const ceReceivedDate = formData.get('ce_received_date'); // <--- FIX: Access scalar fields
    const ceReceivedNote = formData.get('ce_received_note'); // <--- FIX: Access scalar fields
    const ceStatus = formData.get('ce_status');

    let ceUploadFilePath = null;

    // --- 2. File Upload Logic ---
    // The 'file' object retrieved from formData.get is a File object.
    if (file && file instanceof File && file.name) {
        // Use process.cwd() to resolve the absolute path from the project root
        const uploadDir = path.join(process.cwd(), "public", "CE/Recieve_Files");

        // Create directory if it doesn't exist
        if (!fs.existsSync(uploadDir)) {
            fs.mkdirSync(uploadDir, { recursive: true });
            console.log("Created directory:", uploadDir);
        }

        const newFilename = `${Date.now()}_${file.name.replace(/[^a-zA-Z0-9._-]/g, '_')}`; // unique & safe filename
        const newPath = path.join(uploadDir, newFilename);

        // Convert the File object's data to a Node.js Buffer
        const arrayBuffer = await file.arrayBuffer();
        const buffer = Buffer.from(arrayBuffer);

        // Save the file
        fs.writeFileSync(newPath, buffer); 
        console.log("File successfully saved at full path:", newPath);

        // Store ONLY the filename in the database
        ceUploadFilePath = newFilename;
    } else if (file) {
        // This is important for debugging if the file is not a valid File object
        console.error("File object received but failed 'instanceof File' check or name is missing.");
    }


    // --- 3. Prisma Payload Construction ---
    const prismaPayload = {
      ce_received_file: ceUploadFilePath,
      ce_received_date: ceReceivedDate || null, 
      ce_status: Number(ceStatus) || 0, 
      ce_received_note: ceReceivedNote || null,

    };

    console.log("Payload sent to Prisma:", prismaPayload);

    // --- 4. Database Update ---
    const EditingDetails = await CEDetailsUpdate(EdDetailsId, prismaPayload);

    let ce_userName = previousState.user?.user_name;
    let chap_title = previousState.chapter?.chap_title;
    let editor_email = previousState.user?.user_email;
    const subject = `Acknowledgment of uploaded file(s) -<b>${chap_title}</b>`;
    const cc = [];
    const bcc =  process.env.CE_BCCEMAILS ? process.env.CE_BCCEMAILS.split(",").map(email => email.trim()) : [];
    

    // Step 3: Send email (outside transaction)

    const emailContent = `<div style="font-family: Calibri, sans-serif; font-size: 14px; color: black;">Hi ${ce_userName} ,<br/><br/>Thank you for uploading your edited file(s) of the paper titled <b>${chap_title}</b>.<br/>Many thanks for your continued support.<br/><br/>This is an auto-generated acknowledgement email. No action is needed.<br/><br/>Regards,<br/>EBooks</div>`;
    
    const emailResult = await sendEmail(
      editor_email,
      subject,
      emailContent,
      cc,
      bcc
    );
    
    // Step 4: If email fails, rollback to previous state
    if (!emailResult.success) {
      console.error("Email failed, rolling back changes...");
      
      await CEDetailsUpdate(EdDetailsId, {
        ce_status: previousState.ce_status,
        ce_received_file: previousState.ce_received_file,
        ce_received_date: previousState.ce_received_date, 
        ce_received_note: previousState.ce_received_note, 
        
      });
      
      throw new Error("Email sending failed. Changes have been rolled back.");
    }
        
    return {
      success: true,
      message: "Uploaded Successfully",
      EditingDetails,
    };
  } catch (error) {
    console.error("Error updating details:", error);
    return {
      success: false,
      message: "Server error during details update: " + error.message, // Provide error info
    };
  }
}

export async function rejectCEAction(EdDetailsId, payload) {
  let previousState = null;
  let EditingDetails = null;

  try {
    console.log("rejectCEAction called with:", EdDetailsId, payload);

    // Step 1: Get current state for potential rollback
    previousState = await getCEDetailsById(EdDetailsId);

    if (!previousState) {
      throw new Error("Record not found");
    }

    // Step 2: Update the database with rejection details
    EditingDetails = await CEDetailsUpdate(EdDetailsId, payload);

    // --- Prepare Email Content ---
    let ce_userName = previousState.user?.user_name;
    let chap_title = previousState.chapter?.chap_title;
    let editor_email = previousState.user?.user_email;
    const cc = [];
    const bcc =  process.env.CE_BCCEMAILS ? process.env.CE_BCCEMAILS.split(",").map(email => email.trim()) : [];
    const subject = `Confirmation of rejected editing assignment: ${chap_title}`;
    
    const emailContent = `<div style="font-family: Calibri, sans-serif; font-size: 14px; color: black;">Hi ${ce_userName} ,<br/><br/>This email is to confirm that you have declined the copyediting assignment for the paper titled <b>${chap_title}</b>.<br/><br/>This is an auto-generated acknowledgement email. No action is needed.<br/><br/>Regards,<br/>EBooks</div>`;
    // --- End Email Content ---

    // Step 3: Send email
    const emailResult = await sendEmail(
      editor_email,
      subject,
      emailContent,
      cc,
      bcc
    );

    // Step 4: If email fails, rollback to previous state
    if (!emailResult.success) {
      console.error("Email failed, rolling back changes...");

      // Rollback to the state before rejection
      // We restore the fields that the 'payload' would have changed
      await CEDetailsUpdate(EdDetailsId, {
        ce_reject_date: previousState.ce_reject_date, // Should be null or undefined
        ce_status: previousState.ce_status           // The status before rejection (e.g., 'Pending')
      });

      throw new Error("Email sending failed. Changes have been rolled back.");
    }

    // Step 5: Success
    return {
      success: true,
      message: "Rejected Successfully and email sent",
      EditingDetails
    };

  } catch (error) {
    console.error("Error in rejectCEAction:", error);

    return {
      success: false,
      message: error.message || "Server error during rejection process"
    };
  }
}



export async function acceptCEAction(EdDetailsId, payload) {
  let previousState = null;
  let EditingDetails = null;
  
  try {
    console.log("acceptCEAction called with:", EdDetailsId, payload);
    
    // Step 1: Get current state for potential rollback
    previousState = await getCEDetailsById(EdDetailsId);
    
    if (!previousState) {
      throw new Error("Record not found");
    }
    
    // Step 2: Update the database
    EditingDetails = await CEDetailsUpdate(EdDetailsId, payload);
    let ce_userName = previousState.user?.user_name;
    let chap_title = previousState.chapter?.chap_title;
    let editor_email = previousState.user?.user_email;
    const subject = `Acknowledgement for accepting copyediting assignment: ${chap_title}`;
    const cc = [];
    const bcc =  process.env.CE_BCCEMAILS ? process.env.CE_BCCEMAILS.split(",").map(email => email.trim()) : [];
    

    // Step 3: Send email (outside transaction)

    const emailContent = `<div style="font-family: Calibri, sans-serif; font-size: 14px; color: black;">Hi ${ce_userName} ,<br/><br/>Thank you for agreeing to edit the paper titled <b>${chap_title}</b>.<br/><br/>This is an auto-generated acknowledgement email. No action is needed.<br/><br/>Regards,<br/>EBooks</div>`;
    
    const emailResult = await sendEmail(
      editor_email,
      subject,
      emailContent,
      cc,
      bcc
    );
    
    // Step 4: If email fails, rollback to previous state
    if (!emailResult.success) {
      console.error("Email failed, rolling back changes...");
      
      await CEDetailsUpdate(EdDetailsId, {
        ce_accept_date: NULL,
        ce_status: previousState.ce_status
      });
      
      throw new Error("Email sending failed. Changes have been rolled back.");
    }
    
    return {
      success: true,
      message: "Accepted Successfully and email sent",
      EditingDetails
    };
    
  } catch (error) {
    console.error("Error in acceptCEAction:", error);
    
    return {
      success: false,
      message: error.message || "Server error during acceptance process"
    };
  }
}