// app/books/create/actions.js
'use server';

import { createBook, updateBook } from '@/lib/services/bookService';

export async function createBookAction(payload) {
  try {
    const books = await createBook(payload);
    return {
      success: true,
      message: "Book Created Successfully",
      books
    };
  } catch (error) {
    console.error("Error creating book details:", error);
    return {
      success: false,
      message: "Server error during book details"
    };
  }
}

export async function updateBookAction(bookId, payload) {
   try {
    const books = await updateBook(bookId, payload);
    return {
      success: true,
      message: "Book updated Successfully",
      books
    };
  } catch (error) {
    console.error("Error updateing book details:", error);
    return {
      success: false,
      message: "Server error during book details"
    };
  }
}