import Sidebar from "./sidebar";
import Header from "./header";
import Footer from "./footer";
import LayoutClient from "./layout-client";

export default function Layout({ children }) {
  return (
    <LayoutClient>
      <div className="flex h-screen bg-gray-100">
        <Sidebar />
        <div className="flex flex-col flex-1 overflow-hidden">
          <Header />
          <main className="flex-1 overflow-y-auto p-3">{children}</main>
          <Footer />
        </div>
      </div>
    </LayoutClient>
  );
}
