import Sidebar from "./sidebar";
import Header from "./header";
import Footer from "./footer";
import LayoutClient from "./layout-client";

export default function Layout({ children }) {
  return (
    <LayoutClient>
      <div className="flex h-screen bg-gray-100">
        <Sidebar />
        <div className="flex flex-col flex-1 overflow-hidden transition-all duration-300" style={{ paddingLeft: 'calc(var(--sidebar-width, 80px) + 5px)' }}>
          <main className="flex-1 overflow-y-auto p-3 rounded-lg bg-white shadow" style={{ marginLeft:"20px",marginBottom:"5px",marginTop:"10px"}}>{children}</main>
          <Footer/>
        </div>
      </div>
    </LayoutClient>
  );
}
