import { NextResponse } from "next/server";
import { getUserByEmail } from '@/lib/services/userService';
import { generateToken,comparePassword } from '@/lib/utils/authUtils';

export async function POST(request) {
  try {
    const body = await request.json();
    const { email, password } = body;
     
    // Validate input
    if (!email || !password) {
      return NextResponse.json({ error: 'Email and password are required.' }, { status: 400 });
    }

    // Find user by email
    const user = await getUserByEmail(email);

    if (!user) {
      return NextResponse.json({ error: 'User not found.' }, { status: 404 });
    }

    // Compare password
    const isMatch = await comparePassword(password, user.user_hash_password);
    if (!isMatch) {
      return NextResponse.json({ error: 'Incorrect password.' }, { status: 401 });
    }
    //Build JWT payload
    const payload = {
      user_pid: user.user_pid,
      user_email: user.user_email,
      user_name: user.user_name,
      user_role: user.user_role,
      user_profile: user.user_profile,
    };

    // Generate JWT token
    const accessToken = generateToken(payload);

    return NextResponse.json({ message: "Login successfully.",token: accessToken,user: payload}, { status: 200 });

    //  res.cookies.set('token', accessToken, {
    //   httpOnly: true,
    //   secure: true,
    //   path: '/',
    //   maxAge: 60 * 60 * 24 * 7, // 1 week
    // });
    // return res;

  } catch (error) {
    console.error(error);
    return NextResponse.json({ error: "Something went wrong." }, { status: 500 });
  }
}
