import { getServerSession } from "next-auth";

import { updateLogoutTime } from '@/lib/services/userService';
import { getuserLogByEmpId } from '@/lib/services/userService';
import { NextResponse } from 'next/server';
import authOptions from "../[...nextauth]/authOptions";

export async function POST() {
  try {
    const session = await getServerSession(authOptions);

    if (!session || !session.user) {
      // User is not authenticated, no action needed on the server side
      return NextResponse.json({ success: true, message: "No active session." }, { status: 200 });
    }

    const { user_pid } = session.user;
    console.log(user_pid);
    const now = new Date();
    const start_date = now.toISOString().split("T")[0];

    const loginTimeStr = await getuserLogByEmpId(user_pid,start_date);

     // Parse start and end datetime
    const startDateTime = new Date(`${loginTimeStr.log_date}T${loginTimeStr.log_startTime}`);
    const currentTime = new Date();
    const endTime = currentTime.toTimeString().split(" ")[0];
    const endDate = currentTime.toISOString().split("T")[0];
    const endDateTime = new Date(`${endDate}T${endTime}`);

    const durationMs = endDateTime - startDateTime;

    if (durationMs < 0) {
      return { success: false, message: "End time cannot be before start time" };
    }

    // Format duration as HH:MM:SS
    const totalSeconds = Math.floor(durationMs / 1000);
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const seconds = totalSeconds % 60;

    const duration = `${hours.toString().padStart(2, "0")}:${minutes
      .toString()
      .padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;


    // Update the user's logout time in the database
    const updateResult = await updateLogoutTime(user_pid, endDate, endTime,duration);
    // Check if the database update was successful
    if (updateResult.count > 0) {
      // console.log("User logged out:", user_pid);
      return NextResponse.json({ success: true, message: "Logout time updated successfully." }, { status: 200 });
    } else {
      console.error("Failed to update logout time for user:", user_pid);
      return NextResponse.json({ success: false, message: "Database update failed." }, { status: 500 });
    }

  } catch (error) {
    console.error("Logout API error:", error);
    return NextResponse.json({ success: false, error: "Failed to perform logout action." }, { status: 500 });
  }
}