// columns.js
import { FiEdit, FiTrash2 } from "react-icons/fi";
import { Tooltip } from "react-tooltip";

export const getUserColumns = (router, handleDelete) => [
  {
        label: "S.No",
        name: "S.No",
        cell: (row, index) => index + 1,
      },
      {
        label: "User ID",
        name: "User ID",
        selector: (row) => row?.user_empid,
      },
      {
        label: "Name",
        name: "Name",
        selector: (row) => row?.user_name,
      },
      {
        label: "Email",
        name: "Email",
        selector: (row) => row?.user_email,
      },
      {
        label: "Role",
        name: "Role",
        selector: (row) => row?.role?.role_name,
      },
      {
        label: "Profile",
        name: "Profile",
        styleTypeUiPatterns: "badge",
        cell: (row) =>
          row.user_profile ? (
            <img
              src={`/emp_profile/${row?.user_profile}`}
              alt={row.user_name}
              className="h-10 w-10 rounded-full object-cover"
              loading="lazy"
            />
          ) : (
            "No Image"
          ),
      },
      {
        label: "Action",
        name: "Action",
        cell: (row) => (
          <div className="flex space-x-3">
            {/* Edit */}
            <button
              onClick={() => router.push(`/users/create?id=${row?.user_pid}`)}
              data-tooltip-id={`edit-tooltip-${row?.user_pid}`}
              data-tooltip-content="Edit"
              className="text-blue-600 hover:text-blue-800 cursor-pointer"
              type="button"
            >
              <FiEdit size={20} />
              <Tooltip
                id={`edit-tooltip-${row?.user_pid}`}
                place="top"
                style={{
                  backgroundColor: "#3b82f6",
                  color: "#fff",
                  fontSize: "12px",
                  borderRadius: "4px",
                  padding: "6px 10px",
                }}
              />
            </button>

            {/* Delete */}
            <button
              onClick={() => handleDelete(row?.user_pid, row.user_name)}
              data-tooltip-id={`delete-tooltip-${row?.user_pid}`}
              data-tooltip-content="Delete"
              className="text-red-600 hover:text-red-800 cursor-pointer"
              type="button"
            >
              <FiTrash2 size={20} />
              <Tooltip
                id={`delete-tooltip-${row?.user_pid}`}
                place="top"
                style={{
                  backgroundColor: "#ef4444",
                  color: "#fff",
                  fontSize: "12px",
                  borderRadius: "4px",
                  padding: "6px 10px",
                }}
              />
            </button>
          </div>
        ),
        ignoreRowClick: true,
      },
];
