// app/users/create/page.jsx
import Layout from "@/app/components/layout";
import CreateUserForm from "./CreateUserForm";
import { getUserById,getAllRoles } from "@/lib/services/userService";

export const dynamic = "force-dynamic"; // ensure fresh DB read
export const fetchCache = "force-no-store";

export default async function CreateBookPage({ searchParams }) {
    const userId =  searchParams.id;
    const roles = await getAllRoles();
    let user = null;
    if (userId) {
        user = await getUserById(Number(userId));
    }

    return (
        <Layout>
            <CreateUserForm
             roles ={roles}  
             user={user} 
             userId={userId} 
            />
        </Layout>
    );
}