// columns.js

import { FiEdit, FiEye } from "react-icons/fi";
import { Tooltip } from "react-tooltip";
export const getChapterInprogressColumns = (router, setSelectedRow, setIsModalOpen,setEntryId) => [
   {
    label: "S.No",
    name: "S.No",
    cell: (row, index) => index + 1,
    width: "60px",
  },
  {
    label: "Owned By",
    name: "Owned By",
    selector: (row) => row.user.user_name,
  },
  {
    label: "Owned By",
    name: "Owned By",
    selector: (row) => row.user.user_name,
  },
  {
    label: "Start Date",
    name: "Start Date",
    selector: (row) => row.entry_date,
  },

  {
    label: "Book Title",
    name: "Book Title",
    selector: (row) => row.book.book_title,
  },
  {
    label: "Chapter Name",
    name: "Chapter Name",
    selector: (row) => row.chapter.chap_title,
  },
  {
    label: "Task Name",
    name: "Task Name",
    selector: (row) => row.task.task_name,
  },
  {
    label: "Start Time",
    name: "Start Time",
    selector: (row) => row.entry_start_time,
  },

  {
    label: "Action",
    name: "Action",
    width: "120px",
    cell: (row) => (
      <div className="flex space-x-3 text-blue-600">
        <button
          onClick={() => router.push(`/entrys/create?id=${row?.entry_pid}`)}
          data-tooltip-id={`edit-tooltip-${row?.entry_pid}`}
          data-tooltip-content="Edit"
          className="text-blue-600 hover:text-blue-800 cursor-pointer"
          type="button"
        >
          <FiEdit size={20} />
          <Tooltip
            id={`edit-tooltip-${row?.entry_pid}`}
            place="top"
            style={{
              backgroundColor: "#3b82f6",
              color: "#fff",
              fontSize: "12px",
              borderRadius: "4px",
              padding: "6px 10px",
            }}
          />
        </button>
        {/* <button
          onClick={() => {
            setSelectedRow(row);
            setIsModalOpen(true);
            setEntryId(row?.entry_pid);
          }}
          data-tooltip-id={`view-tooltip-${row?.entry_pid}`}
          data-tooltip-content="View"
          className="text-green-600 hover:text-green-800 cursor-pointer"
          type="button"
        >
          <FiEye size={20} />
          <Tooltip
            id={`view-tooltip-${row?.entry_pid}`}
            place="top"
            style={{
              backgroundColor: "#064117",
              color: "#fff",
              fontSize: "12px",
              borderRadius: "4px",
              padding: "6px 10px",
            }}
          />
        </button> */}
      </div>
    ),
    ignoreRowClick: true,
    allowOverflow: true,
    button: true,
  },
];
