// columns.js

import { FiEdit, FiEye } from "react-icons/fi";
import { Tooltip } from "react-tooltip";
export const getChapterCompletedColumns = (router, setSelectedRow, setIsModalOpen, setEntryId) => [
  {
    label: "S.No",
    name: "S.No",
    cell: (row, index) => index + 1,
    width: "60px",
  },
  {
    label: "Owned By",
    name: "Owned By",
    selector: (row) => row.user.user_name,
  },
  {
    label: "Start Date",
    name: "Start Date",
    selector: (row) => row.entry_date,
  },
  {
    label: "End Date",
    name: "End Date",
    selector: (row) => row.entry_end_date,
  },
  {
    label: "Book Title",
    name: "Book Title",
    selector: (row) => row.book.book_title,
  },
  {
    label: "Chapter Name",
    name: "Chapter Name",
    selector: (row) => row.chapter.chap_title,
  },
  {
    label: "Task Name",
    name: "Task Name",
    selector: (row) => row.task.task_name,
  },
  {
    label: "Start Time",
    name: "Start Time",
    selector: (row) => row.entry_start_time,
  },
  {
    label: "End Time",
    name: "End Time",
    selector: (row) => row.entry_end_time,
  },
  {
    label: "Total Duration",
    name: "Total Duration",
    selector: (row) => row.entry_duration,
  },
  {
    label: "Pending Duration",
    name: "Pending Duration",
    selector: (row) => row.total_pending_duration,
  },
  {
    label: "Comments",
    name: "Comments",
    selector: (row) => row.entry_comments,
    omit: true, // This hides Comments column in main DataTable 
  },
  {
    label: "Contact Email",
    name: "Contact Email",
     selector: (row) => row.qcUser?.user_email || "",
    omit: true, // This hides Comments column in main DataTable
  },
  {
    label: "Upload File",
    name: "Upload File",
    selector: (row) => row.entry_file,
    omit: true, // This hides Comments column in main DataTable
  },
  {
    label: "Status",
    name: "Status",
    selector: (row) => (row.status ? row.status.status_name : ""),
  },
  {
    label: "Action",
    name: "Action",
    width: "100px",
    cell: (row) => (
      <div className="flex space-x-3 text-blue-600">
        <button
          onClick={() => {
            setSelectedRow(row);
            setIsModalOpen(true);
            setEntryId(row?.entry_pid);
          }}
          data-tooltip-id={`view-tooltip-${row?.entry_pid}`}
          data-tooltip-content="View"
          className="text-green-600 hover:text-green-800 cursor-pointer"
          type="button"
        >
          <FiEye size={20} />
          <Tooltip
            id={`view-tooltip-${row?.entry_pid}`}
            place="top"
            style={{
              backgroundColor: "#064117",
              color: "#fff",
              fontSize: "12px",
              borderRadius: "4px",
              padding: "6px 10px",
            }}
          />
        </button>
      </div>
    ),
    ignoreRowClick: true,
    allowOverflow: true,
    button: true,
  },
];
