"use client";

import { useEffect, useMemo, useState } from "react";
import { useRouter } from "next/navigation";
import Swal from "sweetalert2";
import { toast } from "react-toastify";
import CustomDataTable from "../../dataTable/customDataTable";
import { getQueriesColumns } from "./columns";
import { queryDeleteAction } from "@/lib/actions/queryAction";
import { useSession } from "next-auth/react";

export default  function QueriesList({ initialQueries }) {
  const [data, setData] = useState(initialQueries || []);
  const [loading, setLoading] = useState(true);
  const router = useRouter();
  const { data: session, status } = useSession();
  const user_pid = session?.user?.user_pid;

  useEffect(() => {
    setData(initialQueries || []);
    setLoading(false);
  }, [initialQueries]);

    const handleDelete = async (queries_pid, queries_name) => {
      const result = await Swal.fire({
        title: "Are you sure?",
        text: `Do you really want to delete the query  "${queries_name}"?`,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#d33",
        cancelButtonColor: "#3085d6",
        confirmButtonText: "Yes, delete it!",
      });

    if (!result.isConfirmed) return;

    try {
      const payload = {
        queries_isdelete: "inactive",
      };
      console.log(payload, 'Payload before delete');
      
      const res = await queryDeleteAction(queries_pid, payload);

      if (res?.success) {
        // ✅ Filter out deleted knowledge from local state
        setData((prevData) =>
          prevData.filter((data) => data.queries_pid !== queries_pid)
        );
        toast.success("query has been deleted.");
      } else {
        toast.error(res?.message || "Failed to delete query.");
      }

      // ✅ Filter out deleted book from local state



    } catch (error) {
      toast.error(error.message || "Error deleting query");
    }
  };



  const columns = useMemo(() => getQueriesColumns(router, handleDelete, user_pid), [router, user_pid]);

  return (
    <div className="max-w-full px-4 py-4 mx-auto bg-white rounded-lg  space-y-4">
      <header>
        <div className="flex justify-between items-center border-b border-purple-500">
          <div className="mb-1">
            <h2 className="text-2xl font-semibold text-gray-800">Queries List</h2>
            <p className="text-gray-500 mt-1 text-sm">
              Below is a list of all Queries.
            </p>
          </div>
          <button
            onClick={() => router.push('/queries/create')}
            className="bg-gradient-to-r from-[#8C3FE1] to-[#E557AE] hover:from-[#6B3DC6] hover:to-[#C64A9B] text-white px-5 py-2 cursor-pointer rounded-md shadow-md text-sm font-medium transition-transform transform hover:scale-105"
          >
            + New Queries
          </button>
        </div>
      </header>

      <CustomDataTable
        columns={columns}
        data={data}
        progressPending={loading}
        defaultSort={{ key: "Queries Name", direction: "ascending" }}
      />
    </div>
  );
}
