import Layout from "@/app/components/layout";
import LogsList from "./LogList";
import { getLogsWithEntriesAndBreaks,getAllUsers } from '@/lib/services/userService';

export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function LogsListPage() {
    const  logs = await getLogsWithEntriesAndBreaks();
     const  users = await getAllUsers();
    return (
        <Layout>
            <LogsList
             initialLogs={logs} 
             initialUsers={users} 
            />
        </Layout>
    );
}