"use client";

import { useEffect, useMemo, useState } from "react";
import { useRouter } from "next/navigation";
import CustomDataTable from "../../(views)/dataTable/customDataTable";
import { getLogColumns } from "./columns";
import Select from "react-select";
export default function LogsList({ initialLogs, initialUsers }) {
  const [data, setData] = useState(initialLogs || []);
    const [filteredData, setFilteredData] = useState([]);
  const [loading, setLoading] = useState(true);
  const [selectedUser, setSelectedUser] = useState(null);
  const [startDate, setStartDate] = useState("");
  const [endDate, setEndDate] = useState("");
  const router = useRouter();

  useEffect(() => {
    setData(initialLogs || []);
    setLoading(false);
  }, [initialLogs]);

 const userOptions = initialUsers.map((u) => ({
    value: String(u.user_pid),
    label: u.user_name.charAt(0).toUpperCase() + u.user_name.slice(1),
  }));

    useEffect(() => {
    const filtered = data.filter((item) => {
      console.log(item);
      const matchesUser = selectedUser ? String(item.user_pid) === selectedUser.value : true;

      const itemDate = new Date(item.log_date);
      const matchesStartDate = startDate ? itemDate >= new Date(startDate) : true;
      const matchesEndDate = endDate ? itemDate <= new Date(endDate) : true;

      return (
        matchesUser &&
        matchesStartDate &&
        matchesEndDate
      );
    });
    setFilteredData(filtered);
  }, [selectedUser, startDate, endDate, data]);

  const columns = useMemo(() => getLogColumns(), []);
const selectStyles = {
    menuPortal: (base) => ({ ...base, zIndex: 9999 }),
  };
  return (
    <div className="max-w-full px-2 py-2 mx-auto rounded-lg space-y-4">
      <header>
        <div className="flex justify-between items-center border-b border-purple-500">
          <div className="mb-1">
            <h2 className="text-2xl font-semibold text-gray-800">Log Detail Lists</h2>
            <p className="text-gray-500 mt-1 text-sm">
              Below is a list of all logs.
            </p>
          </div>
        </div>
      </header>
      <div className="bg-purple-50 border border-purple-200 rounded-lg p-2 shadow-sm">
        <div className="flex flex-wrap gap-4 items-center justify-start">
          {/* User Filter */}
          <div className="flex flex-col">
            <label className="text-xs text-gray-600 font-semibold mb-1">
              User
            </label>
            <Select
              instanceId="user-filter"
              options={userOptions}
              value={selectedUser}
              onChange={setSelectedUser}
              placeholder="Select User"
              isClearable
              className="w-48 text-sm"
              menuPortalTarget={document.body}
              styles={selectStyles}
            />
          </div>


          {/* Start Date */}
          <div className="flex flex-col">
            <label className="text-xs text-gray-600 font-semibold mb-1">
              Start Date
            </label>
            <input
              type="date"
              className="w-40 border border-gray-300 rounded px-3 py-2 text-sm focus:ring focus:ring-purple-200"
              value={startDate}
              onChange={(e) => setStartDate(e.target.value)}
            />
          </div>

          {/* End Date */}
          <div className="flex flex-col">
            <label className="text-xs text-gray-600 font-semibold mb-1">
              End Date
            </label>
            <input
              type="date"
              className="w-40 border border-gray-300 rounded px-3 py-2 text-sm focus:ring focus:ring-purple-200"
              value={endDate}
              onChange={(e) => setEndDate(e.target.value)}
              min={startDate}
            />
          </div>

          {/* Clear Filters Button */}
          <div className="pt-5">
            <button
              onClick={() => {
                setSelectedUser(null);
                setStartDate("");
                setEndDate("");
              }}
              className="text-sm px-4 py-2 bg-purple-100 hover:bg-purple-200 text-purple-700 rounded transition-all duration-200 cursor-pointer"
            >
              Clear Filters
            </button>
          </div>
        </div>
      </div>

      <CustomDataTable
        columns={columns}
        data={filteredData}
        progressPending={loading}
        defaultSort={{ key: "Emp ID", direction: "ascending" }}
      />
    </div>
  );
}
