// columns.js
import { FiEdit, FiTrash2 } from "react-icons/fi";
import { Tooltip } from "react-tooltip";

const isPastDate = (dateStr) => {
  const today = new Date();
  today.setHours(0, 0, 0, 0);
  const holidayDate = new Date(dateStr);
  holidayDate.setHours(0, 0, 0, 0);
  return holidayDate < today;
};

export const getHolidayColumns = (router, handleDelete, role) => {
  const Role = Number(role);
  const columns = [
    {
      label: 'S.No',
      name: 'S.No',
      cell: (_row, index) => index + 1,
    },
    {
      label: 'Holiday Name',
      name: 'Holiday Name',
      selector: (row) => row.holiday_name,
    },
    {
      label: 'Holiday Date',
      name: 'Holiday Date',
      selector: (row) => row.holiday_date,
    },
    {
      label: 'Holiday Day',
      name: 'Holiday Day',
      selector: (row) => {
        const date = new Date(row.holiday_date);
        return isNaN(date.getTime())
          ? 'Invalid Date'
          : date.toLocaleDateString('en-US', { weekday: 'long' });
      },
    },
    {
      label: 'Type',
      name: 'Type',
      selector: (row) => row.holiday_OfficeType,
    },
  ];

  // ✅ Add Action column only for specific roles
  if (Role !== 3) {
    columns.push({
      label: 'Action',
      name: 'Action',
      cell: (row) => {
        const isPast = isPastDate(row.holiday_date);
        if (isPast) return null;

        return (
          <div className="flex space-x-3">
            {/* Edit */}
            <button
              onClick={() => router.push(`/holidays/create?id=${row.holiday_pid}`)}
              data-tooltip-id={`edit-tooltip-${row.holiday_pid}`}
              data-tooltip-content="Edit"
              className="text-blue-600 hover:text-blue-800 cursor-pointer"
              type="button"
            >
              <FiEdit size={20} />
              <Tooltip
                id={`edit-tooltip-${row.holiday_pid}`}
                place="top"
                style={{
                  backgroundColor: '#3b82f6',
                  color: '#fff',
                  fontSize: '12px',
                  borderRadius: '4px',
                  padding: '6px 10px',
                }}
              />
            </button>

            {/* Delete */}
            <button
              onClick={() => handleDelete(row.holiday_pid, row.holiday_name)}
              data-tooltip-id={`delete-tooltip-${row.holiday_pid}`}
              data-tooltip-content="Delete"
              className="text-red-600 hover:text-red-800 cursor-pointer"
              type="button"
            >
              <FiTrash2 size={20} />
              <Tooltip
                id={`delete-tooltip-${row.holiday_pid}`}
                place="top"
                style={{
                  backgroundColor: '#ef4444',
                  color: '#fff',
                  fontSize: '12px',
                  borderRadius: '4px',
                  padding: '6px 10px',
                }}
              />
            </button>
          </div>
        );
      },
      ignoreRowClick: true,
    });
  }

  return columns;
};
