// app/holidays/create/page.jsx
import Layout from "@/app/components/layout";
import CreateHolidayForm from "./CreateHolidayForm";
import { getHolidayById } from "@/lib/services/holidayService";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"

export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function CreateHolidayPage({ searchParams }) {
    const session = await getServerSession(authOptions);
    const user_pid = session?.user.user_pid;
    // const holidayId = await searchParams.id;
    const params = await searchParams;
    const holidayId = params.id;

    let holiday = null;
    if (holidayId) {
        holiday = await getHolidayById(Number(holidayId));
    }

    return (
        <Layout>
            <CreateHolidayForm
                holiday={holiday}
                holidayId={holidayId}
                user_pid = {user_pid}
            />
        </Layout>
    );
}