// app/chapters/create/page.jsx
import Layout from "@/app/components/layout";
import CreateEntryForm from "./CreateEntryForm";
import { getAllBooksList} from "@/lib/services/bookService";
import { getAllTasks, getAllEntryStatus, getAllQCEmails, getEntryById, getPendingById } from "@/lib/services/entryService";
import { notFound } from "next/navigation";
import { getAllChapters } from '@/lib/services/chapterService';
import { getAllBreaks } from '@/lib/services/BreaksServices';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"

export const dynamic = "force-dynamic";

export default async function CreateEntryPage({ searchParams }) {

    // const entryId = searchParams.id;
    const params = await searchParams;
    const entryId = params.id;
    
    const session = await getServerSession(authOptions);
    const user_pid = session?.user.user_pid;

    // Fetch books + pstatus server-side
    const [userbooklist, tasks, entrystatus, emails, chapters, breaks, pending, entry] = await Promise.all([
        getAllBooksList(user_pid),
        getAllTasks(),
        getAllEntryStatus(),
        getAllQCEmails(),
        getAllChapters(),
        getAllBreaks(),
        getPendingById(entryId),
        entryId ? getEntryById(entryId) : null,
    ]);

    if (entryId && !entry) {
        notFound();
    }
    
    // console.log(breaks);
    return (
        <Layout>
            <CreateEntryForm
                initialBooks={userbooklist}
                //initialUserBooks={userbooklist}
                initialtasks={tasks}
                initialstatus={entrystatus}
                initialemails={emails}
                initialchapters={chapters}
                initialbreaks={breaks}
                initialPending = {pending}
                entry={entry}
                fentryId={entryId}
            />
        </Layout>
    );
}
