import Layout from "@/app/components/layout";
import ChaptersCompletedList from "./ChapterCompletedList";
import { getAllCompletedEntrys,getAllTasks } from '@/lib/services/entryService';
import { getAllBooks } from "@/lib/services/bookService";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"

export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function CompletedEntryListPage() {
    const session = await getServerSession(authOptions);
    const userId = session?.user.user_pid;
    const chapterCompleteds = await getAllCompletedEntrys(userId);
    const books = await getAllBooks();
    const tasks = await getAllTasks();
    // console.log(books);
    return (
        <Layout>
            <ChaptersCompletedList
                initialCompleteds={chapterCompleteds}
                initialBooks={books}
                initialtasks={tasks}
            />
        </Layout>
    );
}